/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.query.TermQueryFactory;
import com.atlassian.jira.jql.util.JqlCascadingSelectLiteralUtil;
import com.atlassian.jira.jql.util.JqlSelectOptionsUtil;
import com.atlassian.jira.util.NonInjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

@NonInjectableComponent
public class CascadingSelectCustomFieldClauseQueryFactory
implements ClauseQueryFactory {
    private static final Logger log = Logger.getLogger(CascadingSelectCustomFieldClauseQueryFactory.class);
    private final JqlCascadingSelectLiteralUtil jqlCascadingSelectLiteralUtil;
    private final JqlSelectOptionsUtil jqlSelectOptionsUtil;
    private final JqlOperandResolver jqlOperandResolver;
    private final String parentFieldName;
    private final String childFieldName;
    private final CustomField customField;

    public CascadingSelectCustomFieldClauseQueryFactory(CustomField customField, String luceneField, JqlSelectOptionsUtil jqlSelectOptionsUtil, JqlOperandResolver jqlOperandResolver, JqlCascadingSelectLiteralUtil jqlCascadingSelectLiteralUtil) {
        this.customField = (CustomField)Assertions.notNull((String)"customField", (Object)customField);
        this.jqlSelectOptionsUtil = (JqlSelectOptionsUtil)Assertions.notNull((String)"jqlSelectOptionsUtil", (Object)jqlSelectOptionsUtil);
        this.jqlOperandResolver = (JqlOperandResolver)Assertions.notNull((String)"jqlOperandResolver", (Object)jqlOperandResolver);
        this.jqlCascadingSelectLiteralUtil = (JqlCascadingSelectLiteralUtil)Assertions.notNull((String)"jqlCascadingSelectLiteralUtil", (Object)jqlCascadingSelectLiteralUtil);
        this.parentFieldName = Assertions.notBlank((String)"luceneField", (String)luceneField);
        this.childFieldName = Assertions.notBlank((String)"luceneField", (String)luceneField) + ":1";
    }

    public QueryFactoryResult getQuery(QueryCreationContext queryCreationContext, TerminalClause terminalClause) {
        Operator operator = terminalClause.getOperator();
        boolean isNegationOperator = this.isNegationOperator(operator);
        if (!this.handlesOperator(operator)) {
            log.warn((Object)String.format("Unable to handle operator '%s' for clause '%s'.", operator.getDisplayString(), terminalClause.toString()));
            return QueryFactoryResult.createFalseResult();
        }
        List literals = this.jqlOperandResolver.getValues(queryCreationContext, terminalClause.getOperand(), terminalClause);
        ArrayList<QueryLiteral> positiveLiterals = new ArrayList<QueryLiteral>();
        ArrayList<QueryLiteral> negativeLiterals = new ArrayList<QueryLiteral>();
        if (literals != null) {
            this.processPositiveNegativeOptionLiterals(literals, positiveLiterals, negativeLiterals);
        }
        BooleanQuery combined = new BooleanQuery();
        BooleanQuery positiveQuery = this.getQueryFromLiterals(isNegationOperator, positiveLiterals);
        BooleanQuery negativeQuery = this.getQueryFromLiterals(!isNegationOperator, negativeLiterals);
        if (positiveQuery != null && negativeQuery != null) {
            BooleanClause.Occur occur = isNegationOperator ? BooleanClause.Occur.SHOULD : BooleanClause.Occur.MUST;
            combined.add((Query)positiveQuery, occur);
            combined.add((Query)negativeQuery, occur);
        } else if (positiveQuery != null) {
            combined = positiveQuery;
        } else if (negativeQuery != null) {
            combined = negativeQuery;
        }
        return new QueryFactoryResult((Query)combined, false);
    }

    void processPositiveNegativeOptionLiterals(List<QueryLiteral> literals, List<QueryLiteral> positiveLiterals, List<QueryLiteral> negativeLiterals) {
        this.jqlCascadingSelectLiteralUtil.processPositiveNegativeOptionLiterals(literals, positiveLiterals, negativeLiterals);
    }

    BooleanQuery getQueryFromLiterals(boolean negationOperator, List<QueryLiteral> literals) {
        boolean anyLiteralsFound;
        ArrayList<Long> parentIds = new ArrayList<Long>();
        ArrayList<Long> childIds = new ArrayList<Long>();
        boolean emptyLiteralFound = this.processParentChildOptionLiterals(literals, parentIds, childIds);
        boolean nonEmptyLiteralsFound = !parentIds.isEmpty() || !childIds.isEmpty();
        boolean bl = anyLiteralsFound = emptyLiteralFound || nonEmptyLiteralsFound;
        if (!anyLiteralsFound) {
            return null;
        }
        BooleanClause.Occur occur = negationOperator ? BooleanClause.Occur.MUST_NOT : BooleanClause.Occur.SHOULD;
        BooleanQuery combined = new BooleanQuery();
        for (Long parentId : parentIds) {
            combined.add(this.createParentTerm(parentId), occur);
        }
        for (Long childId : childIds) {
            combined.add(this.createChildTerm(childId), occur);
        }
        if (negationOperator) {
            BooleanQuery nonEmptyQuery = this.createNonEmptyQuery();
            if (nonEmptyLiteralsFound) {
                combined.add((Query)nonEmptyQuery, BooleanClause.Occur.MUST);
                combined.add(TermQueryFactory.visibilityQuery((String)this.parentFieldName), BooleanClause.Occur.MUST);
            } else {
                combined = nonEmptyQuery;
            }
        } else if (emptyLiteralFound) {
            BooleanQuery emptyQuery = this.createEmptyQuery();
            if (nonEmptyLiteralsFound) {
                combined.add((Query)emptyQuery, BooleanClause.Occur.SHOULD);
            } else {
                combined = emptyQuery;
            }
        }
        return combined;
    }

    boolean processParentChildOptionLiterals(List<QueryLiteral> literals, List<Long> parentIds, List<Long> childIds) {
        boolean emptyLiteralFound = false;
        if (literals != null && !literals.isEmpty()) {
            for (QueryLiteral literal : literals) {
                List<Option> optionList = this.jqlSelectOptionsUtil.getOptions(this.customField, literal, true);
                for (Option option : optionList) {
                    if (option != null) {
                        if (option.getParentOption() == null) {
                            parentIds.add(option.getOptionId());
                            continue;
                        }
                        childIds.add(option.getOptionId());
                        continue;
                    }
                    emptyLiteralFound = true;
                }
            }
        }
        return emptyLiteralFound;
    }

    private Query createParentTerm(Long parentId) {
        return new TermQuery(new Term(this.parentFieldName, parentId.toString()));
    }

    private Query createChildTerm(Long childId) {
        return new TermQuery(new Term(this.childFieldName, childId.toString()));
    }

    private BooleanQuery createNonEmptyQuery() {
        BooleanQuery query = new BooleanQuery();
        query.add(TermQueryFactory.nonEmptyQuery((String)this.parentFieldName), BooleanClause.Occur.SHOULD);
        query.add(TermQueryFactory.nonEmptyQuery((String)this.childFieldName), BooleanClause.Occur.SHOULD);
        return query;
    }

    private BooleanQuery createEmptyQuery() {
        BooleanQuery parentQuery = new BooleanQuery();
        parentQuery.add(TermQueryFactory.nonEmptyQuery((String)this.parentFieldName), BooleanClause.Occur.MUST_NOT);
        parentQuery.add(TermQueryFactory.visibilityQuery((String)this.parentFieldName), BooleanClause.Occur.MUST);
        BooleanQuery query = new BooleanQuery();
        query.add((Query)parentQuery, BooleanClause.Occur.MUST);
        query.add(TermQueryFactory.nonEmptyQuery((String)this.childFieldName), BooleanClause.Occur.MUST_NOT);
        return query;
    }

    private boolean handlesOperator(Operator operator) {
        return OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY.contains(operator);
    }

    private boolean isNegationOperator(Operator operator) {
        return Operator.NOT_EQUALS == operator || Operator.NOT_IN == operator || Operator.IS_NOT == operator;
    }
}

