/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.thumbnail;

import com.atlassian.core.util.thumbnail.Thumber;
import com.atlassian.core.util.thumbnail.Thumbnail;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.ThumbnailConfiguration;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.thumbnail.AdaptiveThresholdPredicate;
import com.atlassian.jira.issue.thumbnail.AtlassianCoreThumbnail;
import com.atlassian.jira.issue.thumbnail.BrokenThumbnail;
import com.atlassian.jira.issue.thumbnail.Dimensions;
import com.atlassian.jira.issue.thumbnail.ThumbnailManager;
import com.atlassian.jira.issue.thumbnail.ThumbnailedImage;
import com.atlassian.jira.util.AttachmentUtils;
import com.atlassian.jira.util.io.InputStreamConsumer;
import com.atlassian.jira.util.log.OneShotLogger;
import com.atlassian.jira.util.mime.MimeManager;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.util.concurrent.Function;
import com.atlassian.util.concurrent.ManagedLock;
import com.atlassian.util.concurrent.ManagedLocks;
import com.atlassian.util.concurrent.Supplier;
import com.google.common.base.Predicate;
import com.sun.media.jai.codec.SeekableStream;
import java.awt.Dimension;
import java.awt.RenderingHints;
import java.awt.color.CMMException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.JAI;
import javax.media.jai.OpImage;
import javax.media.jai.RenderedOp;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class DefaultThumbnailManager
implements ThumbnailManager {
    private static final Logger log = Logger.getLogger(DefaultThumbnailManager.class);
    private static final OneShotLogger jaiMessageLog = new OneShotLogger(log);
    private final ThumbnailConfiguration thumbnailConfiguration;
    private final AttachmentManager attachmentManager;
    private final MimeManager mimeManager;
    private final ApplicationProperties applicationProperties;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final Predicate<Dimensions> rasterBasedRenderingThreshold;
    private final Function<Long, ManagedLock.ReadWrite> lockFactory = ManagedLocks.weakReadWriteManagedLockFactory();

    public DefaultThumbnailManager(ThumbnailConfiguration thumbnailConfiguration, AttachmentManager attachmentManager, MimeManager mimeManager, ApplicationProperties applicationProperties, VelocityRequestContextFactory velocityRequestContextFactory) {
        this.thumbnailConfiguration = thumbnailConfiguration;
        this.attachmentManager = attachmentManager;
        this.mimeManager = mimeManager;
        this.applicationProperties = applicationProperties;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.rasterBasedRenderingThreshold = new AdaptiveThresholdPredicate();
    }

    public Collection<Thumbnail> getThumbnails(Collection<Attachment> attachments, Issue issue) throws Exception {
        ArrayList<Thumbnail> thumbnails = new ArrayList<Thumbnail>();
        for (Attachment attachment : attachments) {
            if (!this.isThumbnailable(attachment)) continue;
            thumbnails.add(this.doGetThumbnail(issue, attachment));
        }
        return thumbnails;
    }

    public Collection<Thumbnail> getThumbnails(Issue issue, User user) throws Exception {
        return this.getThumbnails(this.attachmentManager.getAttachments(issue), issue);
    }

    public boolean isThumbnailable(Issue issue, Attachment attachment) throws DataAccessException {
        File attachmentFile;
        if (attachment.isThumbnailable() != null) {
            return attachment.isThumbnailable();
        }
        if (!this.checkToolkit()) {
            return false;
        }
        String mimeType = this.mimeManager.getSuggestedMimeType(attachment.getFilename());
        boolean thumbnailable = false;
        File file = attachmentFile = issue == null ? AttachmentUtils.getAttachmentFile((Attachment)attachment) : AttachmentUtils.getAttachmentFile((Issue)issue, (Attachment)attachment);
        if (this.getThumber().isFileSupportedImage(attachmentFile)) {
            for (String thumbnailMimeType : Thumber.THUMBNAIL_MIME_TYPES) {
                if (!thumbnailMimeType.equalsIgnoreCase(mimeType)) continue;
                thumbnailable = true;
            }
        }
        this.attachmentManager.setThumbnailable(attachment, thumbnailable);
        return thumbnailable;
    }

    public boolean isThumbnailable(Attachment attachment) throws DataAccessException {
        return this.isThumbnailable(attachment.getIssueObject(), attachment);
    }

    public Thumbnail getThumbnail(Attachment attachment) {
        return this.getThumbnail(attachment.getIssueObject(), attachment);
    }

    public Thumbnail getThumbnail(Issue issue, Attachment attachment) {
        if (!this.isThumbnailable(issue, attachment)) {
            return null;
        }
        try {
            return this.doGetThumbnail(issue, attachment);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Error getting thumbnail for: " + attachment, e);
        }
    }

    public boolean checkToolkit() {
        return this.getThumber().checkToolkit();
    }

    public ThumbnailedImage toThumbnailedImage(@Nullable Thumbnail thumbnail) {
        if (thumbnail == null) {
            return null;
        }
        return new AtlassianCoreThumbnail(this.applicationProperties, this.velocityRequestContextFactory.getJiraVelocityRequestContext(), thumbnail);
    }

    private Thumber getThumber() {
        return new Thumber(MIME_TYPE);
    }

    private Thumbnail doGetThumbnail(Issue issue, final Attachment attachment) throws MalformedURLException {
        if (!this.isThumbnailable(issue, attachment)) {
            throw new IllegalArgumentException("Unable to create thumbnail image of attachment with id:" + attachment.getId());
        }
        final File originalFile = issue == null ? AttachmentUtils.getAttachmentFile((Attachment)attachment) : AttachmentUtils.getAttachmentFile((Issue)issue, (Attachment)attachment);
        final File thumbnailFile = issue == null ? AttachmentUtils.getThumbnailFile((Attachment)attachment) : AttachmentUtils.getThumbnailFile((Issue)issue, (Attachment)attachment);
        final int maxWidth = this.thumbnailConfiguration.getMaxWidth();
        final int maxHeight = this.thumbnailConfiguration.getMaxHeight();
        Thumbnail ret = this.readThumbnail(attachment, thumbnailFile);
        if (ret != null) {
            return ret;
        }
        return (Thumbnail)((ManagedLock.ReadWrite)this.lockFactory.get((Object)attachment.getId())).write().withLock((Supplier)new Supplier<Thumbnail>(){

            public Thumbnail get() {
                try {
                    Thumbnail ret = DefaultThumbnailManager.this.readThumbnail(attachment, thumbnailFile);
                    if (ret != null) {
                        return ret;
                    }
                    FileUtils.touch((File)thumbnailFile);
                    FileUtils.deleteQuietly((File)thumbnailFile);
                    Dimensions originalImageDimensions = DefaultThumbnailManager.this.imageDimensions(attachment);
                    if (!DefaultThumbnailManager.this.rasterBasedRenderingThreshold.apply((Object)originalImageDimensions)) {
                        log.debug((Object)"Image dimensions exceed the threshold for raster based image manipulation. Using stream based renderer.");
                        try {
                            return DefaultThumbnailManager.this.generateWithStreamRenderer(attachment, thumbnailFile, maxWidth, maxHeight);
                        }
                        catch (CMMException cme) {
                            log.warn((Object)("Attachment image is very large and contains color information that JIRA cant handle : '" + originalFile + "'"));
                            return new BrokenThumbnail(attachment.getId());
                        }
                    }
                    try {
                        return (Thumbnail)DefaultThumbnailManager.this.withStreamConsumer(attachment, new InputStreamConsumer<Thumbnail>(){

                            @Override
                            public Thumbnail withInputStream(InputStream is) throws MalformedURLException {
                                return DefaultThumbnailManager.this.fixup(DefaultThumbnailManager.this.getThumber().retrieveOrCreateThumbNail(is, attachment.getFilename(), thumbnailFile, maxWidth, maxHeight, attachment.getId().longValue()), thumbnailFile);
                            }
                        });
                    }
                    catch (CMMException ce) {
                        log.debug((Object)("Failed to create thumbnail, delegating to JAI based thumbnail renderer: CMMException " + ce.getLocalizedMessage()));
                        return DefaultThumbnailManager.this.generateWithInMemoryJAIRenderer(attachment, thumbnailFile, maxWidth, maxHeight);
                    }
                }
                catch (IOException e) {
                    log.warn((Object)("Error writing to thumbnail file: " + thumbnailFile), (Throwable)e);
                    return new BrokenThumbnail(attachment.getId());
                }
            }
        });
    }

    private Thumbnail readThumbnail(final Attachment attachment, final File thumbnailFile) {
        return (Thumbnail)((ManagedLock.ReadWrite)this.lockFactory.get((Object)attachment.getId())).read().withLock((Supplier)new Supplier<Thumbnail>(){

            public Thumbnail get() {
                if (thumbnailFile.exists()) {
                    log.debug((Object)("Thumbnail file '" + thumbnailFile + "' already exists. Returning existing thumbnail."));
                    try {
                        BufferedImage image = ImageIO.read(thumbnailFile);
                        if (image != null) {
                            return new Thumbnail(image.getHeight(), image.getWidth(), thumbnailFile.getName(), attachment.getId().longValue(), Thumbnail.MimeType.PNG);
                        }
                        log.warn((Object)("Unable to read image data from  existing thumbnail file '" + thumbnailFile + "'.  Deleting this thumbnail"));
                        FileUtils.deleteQuietly((File)thumbnailFile);
                    }
                    catch (IOException ioe) {
                        log.warn((Object)("Unable to render existing thumbnail file: " + thumbnailFile), (Throwable)ioe);
                        return new BrokenThumbnail(attachment.getId());
                    }
                }
                return null;
            }
        });
    }

    private Thumbnail fixup(@Nullable Thumbnail thumbnail, File thumbnailFile) {
        if (thumbnail == null) {
            return null;
        }
        return new Thumbnail(thumbnail.getHeight(), thumbnail.getWidth(), thumbnailFile.getName(), thumbnail.getAttachmentId(), thumbnail.getMimeType());
    }

    private Thumbnail generateWithInMemoryJAIRenderer(final Attachment attachment, final File thumbnailFile, final int maxWidth, final int maxHeight) throws IOException {
        return this.withStreamConsumer(attachment, new InputStreamConsumer<Thumbnail>(){

            @Override
            public Thumbnail withInputStream(InputStream is) throws IOException {
                jaiMessageLog.warn((Object)"The first time we call the JAI library it may fail to find the native library implementation.  The following output is harmless but unpreventable and hence this precending log message.");
                Dimensions d = new JAIImageRenderer().renderThumbnail(is, thumbnailFile, maxWidth, maxHeight);
                return new Thumbnail(d.getHeight(), d.getWidth(), thumbnailFile.getName(), attachment.getId().longValue(), Thumbnail.MimeType.PNG);
            }
        });
    }

    private Thumbnail generateWithStreamRenderer(final Attachment attachment, final File thumbnailFile, final int maxWidth, final int maxHeight) throws IOException {
        return this.withStreamConsumer(attachment, new InputStreamConsumer<Thumbnail>(){

            @Override
            public Thumbnail withInputStream(InputStream is) throws IOException {
                Dimensions d = new StreamingImageRenderer().renderThumbnail(is, thumbnailFile, maxWidth, maxHeight);
                return new Thumbnail(d.getHeight(), d.getWidth(), thumbnailFile.getName(), attachment.getId().longValue(), Thumbnail.MimeType.PNG);
            }
        });
    }

    private Dimensions imageDimensions(Attachment attachment) throws IOException {
        return this.withStreamConsumer(attachment, new InputStreamConsumer<Dimensions>(){

            @Override
            public Dimensions withInputStream(InputStream is) throws IOException {
                return new ImageDimensionsHelper().dimensionsForImage(ImageIO.createImageInputStream(is));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withStreamConsumer(Attachment attachment, InputStreamConsumer<T> sc) throws IOException {
        T t;
        File attachmentFile = AttachmentUtils.getAttachmentFile((Attachment)attachment);
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(attachmentFile));
            t = sc.withInputStream(inputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return t;
    }

    private static class ImageDimensionsHelper {
        private ImageDimensionsHelper() {
        }

        public Dimensions dimensionsForImage(ImageInputStream inputStream) throws IOException {
            Iterator<ImageReader> readers = ImageIO.getImageReaders(inputStream);
            if (!readers.hasNext()) {
                throw new IOException("There is not ImageReader availble for the given ImageInputStream");
            }
            ImageReader reader = readers.next();
            reader.setInput(inputStream);
            return new Dimensions(reader.getWidth(0), reader.getHeight(0));
        }
    }

    private static class StreamingImageRenderer {
        private StreamingImageRenderer() {
        }

        public Dimensions renderThumbnail(InputStream inputStream, File thumbnailFile, int maxWidth, int maxHeight) throws IOException {
            ImageInputStream iis = ImageIO.createImageInputStream(inputStream);
            BufferedImage bi = this.scaleDown(iis, maxWidth, maxHeight);
            ImageIO.write((RenderedImage)bi, "png", thumbnailFile);
            return new Dimensions(bi.getWidth(), bi.getHeight());
        }

        private BufferedImage scaleDown(ImageInputStream inputStream, int maxWidth, int maxHeight) throws IOException {
            Iterator<ImageReader> readers = ImageIO.getImageReaders(inputStream);
            if (!readers.hasNext()) {
                throw new IOException("There is not ImageReader availble for the given ImageInputStream");
            }
            ImageReader reader = readers.next();
            ImageReadParam param = reader.getDefaultReadParam();
            reader.setInput(inputStream);
            int ratio = this.maintainAspectRatio(new Dimension(reader.getWidth(0), reader.getHeight(0)), new Dimension(maxWidth, maxHeight));
            param.setSourceSubsampling(ratio, ratio, 0, 0);
            return reader.read(0, param);
        }

        private int maintainAspectRatio(Dimension original, Dimension target) {
            if (original.getWidth() > target.getWidth()) {
                return (int)Math.round(original.getWidth() / target.getWidth());
            }
            if (original.getHeight() > target.getHeight()) {
                return (int)Math.round(original.getHeight() / target.getHeight());
            }
            return 1;
        }
    }

    private class JAIImageRenderer {
        private JAIImageRenderer() {
        }

        public Dimensions renderThumbnail(InputStream inputStream, File thumbnailFile, int maxWidth, int maxHeight) throws IOException {
            Dimensions dimensions;
            BufferedOutputStream thumbnailOutputStream = null;
            try {
                thumbnailOutputStream = new BufferedOutputStream(new FileOutputStream(thumbnailFile));
                dimensions = this.scale(inputStream, thumbnailOutputStream, maxWidth, maxHeight);
            }
            catch (FileNotFoundException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(thumbnailOutputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)thumbnailOutputStream);
            return dimensions;
        }

        private Dimensions scale(InputStream inputStream, OutputStream thumbnail, int maxWidth, int maxHeight) {
            RenderedImage image = this.loadImage(inputStream);
            Thumber.WidthHeightHelper wh = DefaultThumbnailManager.this.getThumber().determineScaleSize(maxWidth, maxHeight, image.getWidth(), image.getHeight());
            double scale = (double)wh.getWidth() / (double)image.getWidth();
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(image);
            pb.add(scale);
            pb.add(scale);
            pb.add(0.0f);
            pb.add(0.0f);
            pb.add(image);
            RenderingHints qualityHints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            image = JAI.create((String)"SubsampleAverage", (ParameterBlock)pb, (RenderingHints)qualityHints);
            JAI.create((String)"encode", (RenderedImage)image, (Object)thumbnail, (Object)"PNG");
            return new Dimensions(image.getWidth(), image.getHeight());
        }

        private RenderedImage loadImage(InputStream inputStream) {
            SeekableStream s = SeekableStream.wrapInputStream((InputStream)inputStream, (boolean)true);
            RenderedOp img = JAI.create((String)"stream", (Object)s);
            ((OpImage)img.getRendering()).setTileCache(null);
            return img;
        }
    }
}

