/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.transformer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.searchers.transformer.FieldFlagOperandRegistry;
import com.atlassian.jira.issue.search.searchers.transformer.NavigatorStructureChecker;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.util.DefaultIndexedInputHelper;
import com.atlassian.jira.issue.search.searchers.util.IndexedInputHelper;
import com.atlassian.jira.issue.transport.ActionParams;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.NonInjectableComponent;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

@NonInjectableComponent
public abstract class IdIndexedSearchInputTransformer<T>
implements SearchInputTransformer {
    private final ClauseNames clauseNames;
    private final String urlParameterName;
    protected final FieldFlagOperandRegistry fieldFlagOperandRegistry;
    protected final JqlOperandResolver operandResolver;
    protected final IndexInfoResolver<T> indexInfoResolver;
    private final NavigatorStructureChecker navigatorStructureChecker;
    private volatile IndexedInputHelper indexedInputHelper;
    private volatile DefaultIndexedInputHelper defaultIndexedInputHelper;

    public IdIndexedSearchInputTransformer(ClauseNames id, IndexInfoResolver<T> indexInfoResolver, JqlOperandResolver operandResolver, FieldFlagOperandRegistry fieldFlagOperandRegistry) {
        this(id, id.getPrimaryName(), indexInfoResolver, operandResolver, fieldFlagOperandRegistry);
    }

    public IdIndexedSearchInputTransformer(ClauseNames clauseNames, String urlParameterName, IndexInfoResolver<T> indexInfoResolver, JqlOperandResolver operandResolver, FieldFlagOperandRegistry fieldFlagOperandRegistry) {
        this.clauseNames = clauseNames;
        this.urlParameterName = urlParameterName;
        this.fieldFlagOperandRegistry = fieldFlagOperandRegistry;
        this.operandResolver = operandResolver;
        this.indexInfoResolver = indexInfoResolver;
        this.navigatorStructureChecker = this.createNavigatorStructureChecker();
    }

    IdIndexedSearchInputTransformer(ClauseNames clauseNames, String urlParameterName, IndexInfoResolver<T> indexInfoResolver, JqlOperandResolver operandResolver, FieldFlagOperandRegistry fieldFlagOperandRegistry, NavigatorStructureChecker navigatorStructureChecker) {
        this.clauseNames = clauseNames;
        this.urlParameterName = urlParameterName;
        this.fieldFlagOperandRegistry = fieldFlagOperandRegistry;
        this.operandResolver = operandResolver;
        this.indexInfoResolver = indexInfoResolver;
        this.navigatorStructureChecker = navigatorStructureChecker;
    }

    public void populateFromParams(User user, FieldValuesHolder fieldValuesHolder, ActionParams actionParams) {
        fieldValuesHolder.put((Object)this.urlParameterName, (Object)actionParams.getValuesForKey(this.urlParameterName));
    }

    public void validateParams(User user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, I18nHelper i18nHelper, ErrorCollection errors) {
    }

    public void populateFromQuery(User user, FieldValuesHolder fieldValuesHolder, Query query, SearchContext searchContext) {
        Set valuesAsStrings = this.getIndexedInputHelper().getAllNavigatorValuesForMatchingClauses(user, this.clauseNames, query, searchContext);
        fieldValuesHolder.put((Object)this.urlParameterName, (Object)valuesAsStrings);
    }

    public boolean doRelevantClausesFitFilterForm(User user, Query query, SearchContext searchContext) {
        return this.navigatorStructureChecker.checkSearchRequest(query, searchContext);
    }

    public Clause getSearchClause(User user, FieldValuesHolder fieldValuesHolder) {
        Set<String> constants = this.getValuesFromHolder(fieldValuesHolder);
        if (constants != null && constants.size() > 0) {
            return this.getClauseForValues(constants);
        }
        return null;
    }

    NavigatorStructureChecker<T> createNavigatorStructureChecker() {
        return new NavigatorStructureChecker(this.clauseNames, true, this.fieldFlagOperandRegistry, this.operandResolver);
    }

    abstract IndexedInputHelper createIndexedInputHelper();

    Clause getClauseForValues(Set<String> values) {
        return this.getIndexedInputHelper().getClauseForNavigatorValues(this.clauseNames.getPrimaryName(), values);
    }

    Set<String> getValuesFromHolder(FieldValuesHolder fieldValuesHolder) {
        List list = (List)fieldValuesHolder.get((Object)this.urlParameterName);
        if (list == null) {
            return null;
        }
        for (Object o : list) {
            if (o instanceof String) continue;
            throw new IllegalArgumentException("Why are we putting non-String values in the FieldValuesHolder for searcher '" + this.urlParameterName + "'???");
        }
        LinkedHashSet<String> strings = new LinkedHashSet<String>(list);
        return strings;
    }

    protected DefaultIndexedInputHelper getDefaultIndexedInputHelper() {
        if (this.defaultIndexedInputHelper == null) {
            this.defaultIndexedInputHelper = new DefaultIndexedInputHelper(this.indexInfoResolver, this.operandResolver, this.fieldFlagOperandRegistry);
        }
        return this.defaultIndexedInputHelper;
    }

    protected IndexedInputHelper getIndexedInputHelper() {
        if (this.indexedInputHelper == null) {
            this.indexedInputHelper = this.createIndexedInputHelper();
        }
        return this.indexedInputHelper;
    }
}

