/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.renderer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.EntityNotFoundException;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.option.ComponentOption;
import com.atlassian.jira.issue.fields.option.GroupTextOption;
import com.atlassian.jira.issue.fields.option.Option;
import com.atlassian.jira.issue.fields.option.TextOption;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstantsWithEmpty;
import com.atlassian.jira.issue.search.searchers.renderer.AbstractProjectConstantsRenderer;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import webwork.action.Action;

public class ComponentSearchRenderer
extends AbstractProjectConstantsRenderer {
    private static final Function<String, AbstractProjectConstantsRenderer.GenericProjectConstantsLabel> MAKE_COMPONENT_LABEL = new Function<String, AbstractProjectConstantsRenderer.GenericProjectConstantsLabel>(){

        public AbstractProjectConstantsRenderer.GenericProjectConstantsLabel get(String input) {
            return new AbstractProjectConstantsRenderer.GenericProjectConstantsLabel(input);
        }
    };
    public static final String NO_COMPONENTS = "-1";
    private static final Logger log = Logger.getLogger(ComponentSearchRenderer.class);
    private ProjectComponentManager projectComponentManager;
    private ProjectManager projectManager;

    public ComponentSearchRenderer(ApplicationProperties applicationProperties, FieldVisibilityManager fieldVisibilityManager, ProjectComponentManager projectComponentManager, ProjectManager projectManager, SimpleFieldSearchConstantsWithEmpty searchConstants, String searcherNameKey, VelocityTemplatingEngine templatingEngine, VelocityRequestContextFactory velocityRequestContextFactory) {
        super(velocityRequestContextFactory, applicationProperties, templatingEngine, fieldVisibilityManager, searchConstants, searcherNameKey);
        this.projectComponentManager = projectComponentManager;
        this.projectManager = projectManager;
    }

    public void addEditParameters(FieldValuesHolder fieldValuesHolder, SearchContext searchContext, User user, Map<String, Object> velocityParameters) {
        Collection selectedValues = (Collection)fieldValuesHolder.get((Object)this.searchConstants.getUrlParameter());
        velocityParameters.put("optionGroups", this.getOptions(user, selectedValues, searchContext));
        velocityParameters.put("selectedValues", selectedValues);
    }

    public void addViewParameters(User user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map<String, Object> velocityParameters) {
        List selectedValues = (List)fieldValuesHolder.get((Object)this.searchConstants.getUrlParameter());
        List<Option> validOptions = this.getValidOptions(user, searchContext);
        ArrayList<String> componentNames = new ArrayList<String>();
        for (String componentId : selectedValues) {
            componentNames.add(this.componentName(user, componentId));
        }
        List selectedObjects = CollectionUtil.transform(componentNames, MAKE_COMPONENT_LABEL);
        velocityParameters.put("selectedObjects", this.filterDuplicateSelectedObjects(selectedObjects, validOptions));
    }

    public String getEditHtml(User user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action) {
        Map<String, Object> velocityParameters = this.getVelocityParams(user, searchContext, null, fieldValuesHolder, displayParameters, action);
        this.addEditParameters(fieldValuesHolder, searchContext, user, velocityParameters);
        return this.renderEditTemplate("project-constants-searcher-edit.vm", velocityParameters);
    }

    public String getViewHtml(User user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action) {
        Map<String, Object> velocityParameters = this.getVelocityParams(user, searchContext, null, fieldValuesHolder, displayParameters, action);
        this.addViewParameters(user, searchContext, fieldValuesHolder, velocityParameters);
        return this.renderViewTemplate("project-constants-searcher-view.vm", velocityParameters);
    }

    protected Map<String, Object> getVelocityParams(User user, SearchContext searchContext, FieldLayoutItem fieldLayoutItem, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action) {
        displayParameters.put("kickass", true);
        return super.getVelocityParams(user, searchContext, fieldLayoutItem, fieldValuesHolder, displayParameters, action);
    }

    private List<Option> getOptions(User user, Collection<String> selectedValues, SearchContext searchContext) {
        if (!searchContext.isSingleProjectContext()) {
            return Collections.emptyList();
        }
        Option empty = this.getEmptyOption(user);
        ArrayList<Option> groups = new ArrayList<Option>();
        List<Option> validOptions = this.getSelectListOptions(user, searchContext);
        ArrayList allOptions = Lists.newArrayList(validOptions);
        allOptions.add(empty);
        this.addOption(groups, "", Lists.newArrayList((Object[])new Option[]{empty}));
        this.addOption(groups, "", validOptions);
        this.addOption(groups, "invalid", this.getInvalidOptions(user, selectedValues, allOptions));
        return groups;
    }

    private ProjectComponent getComponent(Long id) {
        ProjectComponent component;
        try {
            component = this.projectComponentManager.find(id);
        }
        catch (EntityNotFoundException e) {
            throw new RuntimeException("Trying to retrieve non existant component");
        }
        return component;
    }

    private List<Option> getInvalidOptions(User user, Collection<String> selectedKeys, Collection<Option> validOptions) {
        TreeSet<Option> invalidOptions = new TreeSet<Option>();
        if (selectedKeys != null) {
            for (String selectedKey : selectedKeys) {
                String componentName;
                if (this.isValidComponent(selectedKey, validOptions) || null == (componentName = this.componentName(user, selectedKey)) || this.isValidComponentName(componentName, validOptions) || this.containsComponentName(componentName, invalidOptions)) continue;
                invalidOptions.add((Option)new TextOption(selectedKey, componentName, "invalid_sel"));
            }
        }
        return new ArrayList<Option>(invalidOptions);
    }

    private void addOption(List<Option> options, String groupId, Collection<Option> addOptions) {
        ArrayList nonNullOptions = Lists.newArrayList();
        for (Option option : addOptions) {
            if (null == option) continue;
            nonNullOptions.add(option);
        }
        if (!nonNullOptions.isEmpty()) {
            options.add((Option)new GroupTextOption(groupId, "", nonNullOptions));
        }
    }

    private boolean isValidComponent(String key, Collection<Option> validOptions) {
        for (Option option : validOptions) {
            if (!option.getId().equals(key)) continue;
            return true;
        }
        return false;
    }

    private boolean isValidComponentName(String componentName, Collection<Option> validOptions) {
        for (Option option : validOptions) {
            if (!option.getName().equalsIgnoreCase(componentName)) continue;
            return true;
        }
        return false;
    }

    private boolean containsComponentName(String componentName, Set<Option> options) {
        for (Option option : options) {
            if (!componentName.equalsIgnoreCase(option.getName())) continue;
            return true;
        }
        return false;
    }

    private Option getEmptyOption(User user) {
        return new TextOption(NO_COMPONENTS, this.getI18n(user).getText("common.concepts.nocomponent"));
    }

    private String componentName(User searcher, String id) {
        if (NO_COMPONENTS.equals(id)) {
            return this.getI18n(searcher).getText("common.concepts.nocomponent");
        }
        ProjectComponent component = this.getComponent(new Long(id));
        if (null != component) {
            return component.getName();
        }
        return null;
    }

    private List<Option> getValidOptions(User user, SearchContext searchContext) {
        ArrayList options = Lists.newArrayList();
        options.add(this.getEmptyOption(user));
        options.addAll(this.getSelectListOptions(user, searchContext));
        return options;
    }

    @Override
    List<Option> getSelectListOptions(User user, SearchContext searchContext) {
        if (searchContext.isSingleProjectContext()) {
            Long projectID = (Long)searchContext.getProjectIds().get(0);
            if (this.projectManager.getProjectObj(projectID) != null) {
                return CollectionUtil.transform((Iterable)this.projectComponentManager.findAllForProject(projectID), ComponentOption.FUNCTION);
            }
            log.warn((Object)("Project for search context " + searchContext + " is invalid."));
        }
        return Collections.emptyList();
    }
}

