/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.quicksearch;

import com.atlassian.jira.issue.search.quicksearch.PrefixedSingleWordQuickSearchHandler;
import com.atlassian.jira.issue.search.quicksearch.ProjectAwareQuickSearchHandler;
import com.atlassian.jira.issue.search.quicksearch.ProjectAwareQuickSearchHandlerImpl;
import com.atlassian.jira.issue.search.quicksearch.QuickSearchResult;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.RegexpUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.commons.collections.MultiHashMap;
import org.ofbiz.core.entity.GenericValue;

public abstract class VersionQuickSearchHandler
extends PrefixedSingleWordQuickSearchHandler {
    private final VersionManager versionManager;
    private final ProjectAwareQuickSearchHandler projectAwareQuickSearchHandler;

    public VersionQuickSearchHandler(VersionManager versionManager, ProjectManager projectManager, PermissionManager permissionManager, JiraAuthenticationContext authenticationContext) {
        this.versionManager = versionManager;
        this.projectAwareQuickSearchHandler = new ProjectAwareQuickSearchHandlerImpl(projectManager, permissionManager, authenticationContext);
    }

    @Override
    protected Map handleWordSuffix(String versionRegexp, QuickSearchResult searchResult) {
        MultiHashMap versions = new MultiHashMap();
        List possibleProjects = this.projectAwareQuickSearchHandler.getProjects(searchResult);
        String projectId = this.projectAwareQuickSearchHandler.getSingleProjectIdFromSearch(searchResult);
        boolean hasProjectInSearch = projectId != null;
        ArrayList projectsWithVersions = Lists.newArrayList();
        for (GenericValue project : possibleProjects) {
            List projectVersions = VersionQuickSearchHandler.getAllVersionIdsMatchingSubstring(this.versionManager.getVersions(project), versionRegexp);
            versions.putAll((Object)this.getSearchParamName(), (Collection)projectVersions);
            if (hasProjectInSearch || projectVersions.isEmpty()) continue;
            projectsWithVersions.add(project.getString("id"));
        }
        if (projectsWithVersions.size() == 1) {
            String singleProjectWithVersions = (String)projectsWithVersions.get(0);
            this.projectAwareQuickSearchHandler.addProject(singleProjectWithVersions, searchResult);
        }
        return versions;
    }

    public static List getAllVersionIdsMatchingSubstring(Collection<Version> versions, String name) {
        ArrayList<String> versionIdsThatMatch = new ArrayList<String>();
        Pattern p = null;
        if (name.contains("*") || name.contains("?")) {
            p = Pattern.compile(RegexpUtils.wildcardToRegex((String)name));
        }
        for (Version version : versions) {
            String versionName = version.getName();
            if (versionName == null) continue;
            if (p != null) {
                if (!p.matcher(versionName).matches()) continue;
                versionIdsThatMatch.add(version.getId().toString());
                continue;
            }
            StringTokenizer st = new StringTokenizer(versionName, " ");
            while (st.hasMoreTokens()) {
                String word = st.nextToken();
                if (!name.equalsIgnoreCase(word)) continue;
                versionIdsThatMatch.add(version.getId().toString());
            }
        }
        return versionIdsThatMatch;
    }

    @Override
    protected abstract String getPrefix();

    protected abstract String getSearchParamName();
}

