/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.renderer.wiki.embedded;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.attachments.RendererAttachment;
import com.atlassian.renderer.attachments.RendererAttachmentManager;
import com.atlassian.renderer.embedded.EmbeddedImage;
import com.atlassian.renderer.embedded.EmbeddedImageRenderer;
import com.atlassian.renderer.embedded.EmbeddedResource;
import com.atlassian.renderer.v2.RenderUtils;
import com.atlassian.renderer.v2.components.HtmlEscaper;
import com.opensymphony.util.TextUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class JiraEmbeddedImageRenderer
extends EmbeddedImageRenderer {
    private final RendererAttachmentManager attachmentManager;
    private long attachmentId;
    private String attachmentSrc;
    private String attachmentName;
    private boolean isThumbNail;

    public JiraEmbeddedImageRenderer(RendererAttachmentManager attachmentManager) {
        super(attachmentManager);
        this.attachmentManager = attachmentManager;
    }

    public String renderResource(EmbeddedResource resource, RenderContext context) {
        EmbeddedImage image = (EmbeddedImage)resource;
        this.isThumbNail = image.isThumbNail();
        if (this.isThumbNail && !image.isExternal()) {
            try {
                RendererAttachment attachment = this.getAttachment(context, resource);
                this.attachmentId = attachment.getId();
                this.attachmentSrc = attachment.getSrc();
                this.attachmentName = attachment.getFileName();
            }
            catch (RuntimeException re) {
                // empty catch block
            }
        }
        return this.renderResourceCompat(resource, context);
    }

    protected String writeImage(String imageTag, Map<Object, Object> imageParams, RenderContext context) {
        return this.writeImage(imageTag, this.extractCenteredParam(imageParams));
    }

    private String writeImage(String imageTag, boolean centered) {
        if (!centered && !this.isThumbNail) {
            return imageTag;
        }
        StringBuilder sb = new StringBuilder(imageTag.length() + 64);
        if (centered) {
            sb.append("<div align=\"center\">");
        }
        if (this.isThumbNail) {
            sb.append("<a id=\"").append(this.attachmentId).append("_thumb\" href=\"").append(this.attachmentSrc).append("\" title=\"").append(this.attachmentName).append("\">");
        }
        sb.append(imageTag);
        if (this.isThumbNail) {
            sb.append("</a>");
        }
        if (centered) {
            sb.append("</div>");
        }
        return sb.toString();
    }

    private boolean extractCenteredParam(Map imageParams) {
        boolean centered;
        String align = (String)imageParams.get("align");
        boolean bl = centered = "center".equalsIgnoreCase(align) || "centre".equalsIgnoreCase(align);
        if (centered) {
            imageParams.remove("align");
        }
        return centered;
    }

    private String originalLink(EmbeddedResource resource) {
        return "!" + resource.getOriginalLinkText() + '!';
    }

    private String renderResourceCompat(EmbeddedResource resource, RenderContext context) {
        String token;
        EmbeddedImage image = (EmbeddedImage)resource;
        RendererAttachment attachment = null;
        if (!image.isExternal()) {
            try {
                attachment = this.getAttachment(context, resource);
            }
            catch (RuntimeException re) {
                return context.addRenderedContent((Object)RenderUtils.error((String)re.getMessage()));
            }
        }
        HashMap<Object, Object> imageParams = new HashMap<Object, Object>();
        imageParams.putAll(image.getProperties());
        if (context.isRenderingForWysiwyg()) {
            imageParams.put("imagetext", resource.getOriginalLinkText());
        }
        if (image.isThumbNail()) {
            token = image.isExternal() ? context.addRenderedContent((Object)RenderUtils.error((RenderContext)context, (String)"Can only create thumbnails for attached images", (String)this.originalLink(resource), (boolean)false)) : (!this.attachmentManager.systemSupportsThumbnailing() ? context.addRenderedContent((Object)RenderUtils.error((RenderContext)context, (String)"This installation can not generate thumbnails: no image support in Java runtime", (String)this.originalLink(resource), (boolean)false)) : (attachment == null && !context.isRenderingForWysiwyg() ? context.addRenderedContent((Object)RenderUtils.error((RenderContext)context, (String)("Attachment '" + image.getFilename() + "' was not found"), (String)this.originalLink(resource), (boolean)false)) : context.addRenderedContent((Object)this.generateThumbnail(imageParams, attachment, context, image))));
        } else {
            StringBuilder imageUrl = new StringBuilder();
            if (image.isExternal()) {
                imageUrl.append(image.getUrl());
            } else if (attachment != null) {
                if (context.getOutputType().equals("word")) {
                    int index;
                    String contextPath = context.getSiteRoot();
                    String domain = context.getBaseUrl();
                    if (contextPath != null && contextPath.length() != 0 && (index = domain.indexOf(contextPath)) != -1) {
                        domain = domain.substring(0, index);
                    }
                    imageUrl.append(domain);
                }
                imageUrl.append(attachment.getSrc());
            }
            boolean centered = this.extractCenteredParam(imageParams);
            token = context.addRenderedContent((Object)this.writeImage("<img src=\"" + HtmlEscaper.escapeAll((String)imageUrl.toString(), (boolean)false) + "\" " + this.outputParameters(imageParams) + "/>", centered));
        }
        return token;
    }

    private String generateThumbnail(Map<Object, Object> imageParams, RendererAttachment attachment, RenderContext context, EmbeddedImage embeddedImage) {
        if (attachment != null && TextUtils.stringSet((String)attachment.getComment()) && !imageParams.containsKey("title") && !imageParams.containsKey("TITLE")) {
            imageParams.put("title", attachment.getComment());
        }
        RendererAttachment thumb = null;
        if (attachment != null) {
            try {
                thumb = this.getThumbnail(attachment, context, embeddedImage);
            }
            catch (RuntimeException re) {
                return context.addRenderedContent((Object)RenderUtils.error((String)re.getMessage()));
            }
        }
        boolean centered = this.extractCenteredParam(imageParams);
        if (thumb != null) {
            return this.writeImage(thumb.wrapGeneratedElement("<img src=\"" + thumb.getSrc() + "\" " + this.outputParameters(imageParams) + "/>"), centered);
        }
        return this.writeImage("<img " + this.outputParameters(imageParams) + "/>", centered);
    }

    private String outputParameters(Map<Object, Object> params) {
        if (params.isEmpty()) {
            return " border='0' ";
        }
        StringBuilder buff = new StringBuilder(params.size() * 20);
        TreeMap<Object, Object> sortedParams = new TreeMap<Object, Object>(params);
        boolean hasNoBorderSet = true;
        for (Map.Entry param : sortedParams.entrySet()) {
            String key = (String)param.getKey();
            if (hasNoBorderSet && "border".equals(key)) {
                hasNoBorderSet = false;
            }
            buff.append(HtmlEscaper.escapeAll((String)key, (boolean)true)).append("=\"").append(HtmlEscaper.escapeAll((String)((String)param.getValue()), (boolean)true)).append("\" ");
        }
        if (hasNoBorderSet) {
            buff.append(" border='0' ");
        }
        return buff.toString();
    }
}

