/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.transformer;

import com.atlassian.jira.external.beans.ExternalNodeAssociation;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.imports.project.transformer.VersionTransformer;
import org.apache.log4j.Logger;

public class VersionTransformerImpl
implements VersionTransformer {
    private static final Logger log = Logger.getLogger(VersionTransformerImpl.class);

    @Override
    public ExternalNodeAssociation transform(ProjectImportMapper projectImportMapper, ExternalNodeAssociation version) {
        if ("IssueVersion".equals(version.getAssociationType()) || "IssueFixVersion".equals(version.getAssociationType())) {
            String mappedIssueId = projectImportMapper.getIssueMapper().getMappedId(version.getSourceNodeId());
            String mappedVersionId = projectImportMapper.getVersionMapper().getMappedId(version.getSinkNodeId());
            if (mappedIssueId == null) {
                log.error((Object)("Trying to transform an issue version entry which references an old issue id '" + version.getSourceNodeId() + "' which has no mapped value."));
                return null;
            }
            if (mappedVersionId == null) {
                log.warn((Object)("Trying to transform an issue version entry which references an old version with id '" + version.getSinkNodeId() + "' which has no mapped value. The value will be ignored."));
                return null;
            }
            return new ExternalNodeAssociation(mappedIssueId, version.getSourceNodeEntity(), mappedVersionId, version.getSinkNodeEntity(), version.getAssociationType());
        }
        log.warn((Object)("Version transformer unable to transform node association entry of type '" + version.getAssociationType() + "'."));
        return null;
    }
}

