/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.config;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;

public enum DatabaseType {
    HSQL("HSQL", "hsql"),
    SQL_SERVER("SQL Server", "mssql"),
    MY_SQL("MySQL", "mysql"),
    ORACLE("Oracle", "oracle10g"),
    POSTGRES("PostgreSQL", "postgres72"),
    UKNOWN("Uknown", "unknown");

    private final String name;
    private final String typeName;

    private DatabaseType(String name, String typeName) {
        this.name = name;
        this.typeName = typeName;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        return this.name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public static Iterable<DatabaseType> knownTypes() {
        return Iterables.filter(DatabaseType.allTypes(), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)((Object)UKNOWN))));
    }

    public static Iterable<DatabaseType> allTypes() {
        return ImmutableList.copyOf((Object[])DatabaseType.values());
    }

    public static DatabaseType forJdbcDriverClassName(String jdbcDriverClass) {
        if (jdbcDriverClass == null) {
            return HSQL;
        }
        if (jdbcDriverClass.equals("org.hsqldb.jdbcDriver")) {
            return HSQL;
        }
        if (jdbcDriverClass.equals("com.mysql.jdbc.Driver")) {
            return MY_SQL;
        }
        if (jdbcDriverClass.equals("oracle.jdbc.OracleDriver")) {
            return ORACLE;
        }
        if (jdbcDriverClass.equals("org.postgresql.Driver")) {
            return POSTGRES;
        }
        if (jdbcDriverClass.equals("net.sourceforge.jtds.jdbc.Driver")) {
            return SQL_SERVER;
        }
        if (jdbcDriverClass.equals("com.microsoft.jdbc.sqlserver.SQLServerDriver")) {
            return SQL_SERVER;
        }
        throw new IllegalArgumentException("Unknown JDBC Driver Class " + jdbcDriverClass);
    }
}

