/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config;

import com.atlassian.jira.config.IssueConstantFactory;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.issuetype.IssueTypeImpl;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.priority.PriorityImpl;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.resolution.ResolutionImpl;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.issue.status.StatusImpl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.BaseUrl;
import com.atlassian.jira.web.action.admin.translation.TranslationManager;
import org.ofbiz.core.entity.GenericValue;

public class DefaultIssueConstantFactory
implements IssueConstantFactory {
    private final TranslationManager translationManager;
    private final JiraAuthenticationContext authenticationContext;
    private final BaseUrl baseUrl;

    public DefaultIssueConstantFactory(TranslationManager translationManager, JiraAuthenticationContext authenticationContext, BaseUrl baseUrl) {
        this.translationManager = translationManager;
        this.authenticationContext = authenticationContext;
        this.baseUrl = baseUrl;
    }

    @Override
    public Priority createPriority(GenericValue priorityGv) {
        return new PriorityImpl(priorityGv, this.translationManager, this.authenticationContext, this.baseUrl);
    }

    @Override
    public IssueType createIssueType(GenericValue issueTypeGv) {
        return new IssueTypeImpl(issueTypeGv, this.translationManager, this.authenticationContext, this.baseUrl);
    }

    @Override
    public Resolution createResolution(GenericValue resolutionGv) {
        return new ResolutionImpl(resolutionGv, this.translationManager, this.authenticationContext, this.baseUrl);
    }

    @Override
    public Status createStatus(GenericValue statusGv) {
        return new StatusImpl(statusGv, this.translationManager, this.authenticationContext, this.baseUrl);
    }
}

