/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.charts;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.charts.Chart;
import com.atlassian.jira.charts.ChartFactory;
import com.atlassian.jira.charts.jfreechart.ChartHelper;
import com.atlassian.jira.charts.jfreechart.HistogramChartGenerator;
import com.atlassian.jira.charts.jfreechart.util.ChartUtil;
import com.atlassian.jira.charts.util.DataUtils;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.LocalDate;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.util.RedundantClausesQueryOptimizer;
import com.atlassian.jira.issue.statistics.util.DocumentHitCollector;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.jql.util.JqlCustomFieldId;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.velocity.DefaultVelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.query.Query;
import com.atlassian.query.order.SortOrder;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.urls.TimeSeriesURLGenerator;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.xy.XYDataset;
import org.joda.time.DateTime;

class TimeSinceChart {
    private final FieldManager fieldManager;
    private final SearchProvider searchProvider;
    private final IssueIndexManager issueIndexManager;
    private final SearchService searchService;
    private final ApplicationProperties applicationProperties;
    private final TimeZone chartTimeZone;

    public TimeSinceChart(FieldManager fieldManager, SearchProvider searchProvider, IssueIndexManager issueIndexManager, SearchService searchService, ApplicationProperties applicationProperties, TimeZone chartTimeZone) {
        this.fieldManager = fieldManager;
        this.searchProvider = searchProvider;
        this.issueIndexManager = issueIndexManager;
        this.searchService = searchService;
        this.applicationProperties = applicationProperties;
        this.chartTimeZone = chartTimeZone;
    }

    public Chart generateChart(final User remoteUser, final SearchRequest searchRequest, int days, ChartFactory.PeriodName periodName, int width, int height, boolean cumulative, final String dateFieldId) {
        Assertions.notNull((String)"searchRequest", (Object)searchRequest);
        Assertions.notNull((String)"dateFieldId", (Object)dateFieldId);
        try {
            final NavigableField dateField = this.fieldManager.getNavigableField(dateFieldId);
            days = DataUtils.normalizeDaysValue((int)days, (ChartFactory.PeriodName)periodName);
            JqlQueryBuilder queryBuilder = JqlQueryBuilder.newBuilder((Query)searchRequest.getQuery());
            JqlClauseBuilder whereClauseBuilder = queryBuilder.where().defaultAnd();
            whereClauseBuilder.field(this.getJqlFieldIdFor((Field)dateField)).gtEq().string("-" + days + "d");
            final TreeMap<RegularTimePeriod, Number> matchingIssues = new TreeMap<RegularTimePeriod, Number>();
            Class timePeriodClass = ChartUtil.getTimePeriodClass((ChartFactory.PeriodName)periodName);
            GenericDateFieldIssuesHitCollector hitCollector = new GenericDateFieldIssuesHitCollector(matchingIssues, this.issueIndexManager.getIssueSearcher(), dateField.getSorter(), timePeriodClass, dateFieldId, this.chartTimeZone);
            Query query = whereClauseBuilder.buildQuery();
            this.searchProvider.search(query, remoteUser, (Collector)hitCollector);
            DataUtils.normaliseDateRangeCount(matchingIssues, (int)(days - 1), (Class)timePeriodClass, (TimeZone)this.chartTimeZone);
            final I18nBean i18nBean = new I18nBean(remoteUser);
            TimeSeriesCollection originalDataset = DataUtils.getTimeSeriesCollection((List)Lists.newArrayList((Object[])new Map[]{matchingIssues}), (String[])new String[]{dateField.getName()}, (Class)timePeriodClass);
            int numIssues = DataUtils.getTotalNumber(matchingIssues);
            if (cumulative) {
                DataUtils.makeCumulative(matchingIssues);
            }
            TimeSeriesCollection dataset = DataUtils.getTimeSeriesCollection((List)Lists.newArrayList((Object[])new Map[]{matchingIssues}), (String[])new String[]{i18nBean.getText("datacollector.createdresolved")}, (Class)timePeriodClass);
            ChartHelper helper = new HistogramChartGenerator(dataset, i18nBean.getText("common.concepts.issues"), i18nBean).generateChart();
            JFreeChart chart = helper.getChart();
            XYPlot plot = (XYPlot)chart.getPlot();
            XYBarRenderer renderer = (XYBarRenderer)plot.getRenderer();
            renderer.setToolTipGenerator(new XYToolTipGenerator(){

                public String generateToolTip(XYDataset xyDataset, int row, int col) {
                    TimeSeriesCollection timeSeriesCollection = (TimeSeriesCollection)xyDataset;
                    TimeSeries timeSeries = timeSeriesCollection.getSeries(row);
                    TimeSeriesDataItem item = timeSeries.getDataItem(col);
                    RegularTimePeriod period = item.getPeriod();
                    int total = ((Number)matchingIssues.get(period)).intValue();
                    return period.toString() + ": " + total + " " + StringEscapeUtils.escapeHtml((String)dateField.getName()) + " " + i18nBean.getText("datacollector.tooltip.issues") + ".";
                }
            });
            final VelocityRequestContext velocityRequestContext = new DefaultVelocityRequestContextFactory(this.applicationProperties).getJiraVelocityRequestContext();
            TimeSeriesURLGenerator urlGenerator = new TimeSeriesURLGenerator(){

                public String generateURL(XYDataset xyDataset, int row, int col) {
                    TimeSeriesCollection timeSeriesCollection = (TimeSeriesCollection)xyDataset;
                    TimeSeries timeSeries = timeSeriesCollection.getSeries(row);
                    TimeSeriesDataItem item = timeSeries.getDataItem(col);
                    RegularTimePeriod period = item.getPeriod();
                    JqlQueryBuilder jqlQueryBuilder = JqlQueryBuilder.newBuilder((Query)searchRequest.getQuery());
                    Date startDate = period.getStart();
                    Date endDate = new Date(period.getEnd().getTime());
                    jqlQueryBuilder.where().defaultAnd().addDateRangeCondition(TimeSinceChart.this.getJqlFieldIdFor((Field)dateField), startDate, endDate);
                    jqlQueryBuilder.orderBy().addSortForFieldName(dateFieldId, SortOrder.DESC, true);
                    RedundantClausesQueryOptimizer optimizer = new RedundantClausesQueryOptimizer();
                    Query query = optimizer.optimizeQuery(jqlQueryBuilder.buildQuery());
                    return velocityRequestContext.getCanonicalBaseUrl() + "/secure/IssueNavigator.jspa?reset=true" + TimeSinceChart.this.searchService.getQueryString(remoteUser, query);
                }
            };
            renderer.setURLGenerator((XYURLGenerator)urlGenerator);
            plot.setRenderer((XYItemRenderer)renderer);
            helper.generate(width, height);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("chart", helper.getLocation());
            params.put("chartDataset", dataset);
            params.put("completeDataset", originalDataset);
            params.put("completeDatasetUrlGenerator", urlGenerator);
            params.put("numIssues", numIssues);
            params.put("period", periodName.toString());
            params.put("imagemap", helper.getImageMap());
            params.put("imagemapName", helper.getImageMapName());
            params.put("field", dateField);
            params.put("daysPrevious", days);
            params.put("cumulative", cumulative);
            params.put("dateField", dateFieldId);
            params.put("chartFilterUrl", "/secure/IssueNavigator.jspa?reset=true" + this.searchService.getQueryString(remoteUser, query));
            return new Chart(helper.getLocation(), helper.getImageMap(), helper.getImageMapName(), params);
        }
        catch (IOException e) {
            throw new RuntimeException("Error generating chart", e);
        }
        catch (SearchException e) {
            throw new RuntimeException("Error generating chart", e);
        }
    }

    private String getJqlFieldIdFor(Field field) {
        if (field instanceof CustomField) {
            CustomField asCustomField = (CustomField)field;
            return JqlCustomFieldId.toString((long)asCustomField.getIdAsLong());
        }
        return field.getId();
    }

    static class GenericDateFieldIssuesHitCollector
    extends DocumentHitCollector {
        private final Map<RegularTimePeriod, Number> resolvedMap;
        private final LuceneFieldSorter fieldSorter;
        private final Class timePeriodClass;
        private final String dateFieldId;
        private final TimeZone timeZone;

        public GenericDateFieldIssuesHitCollector(Map<RegularTimePeriod, Number> resolvedMap, IndexSearcher searcher, LuceneFieldSorter fieldSorter, Class timePeriodClass, String dateFieldId, TimeZone timeZone) {
            super(searcher);
            this.resolvedMap = resolvedMap;
            this.fieldSorter = fieldSorter;
            this.timePeriodClass = timePeriodClass;
            this.dateFieldId = dateFieldId;
            this.timeZone = timeZone;
        }

        public void collect(Document d) {
            Date date;
            Object dateObject = this.fieldSorter.getValueFromLuceneField(d.get(this.dateFieldId));
            if (dateObject instanceof LocalDate) {
                LocalDate localDate = (LocalDate)dateObject;
                date = new DateTime(localDate.getYear(), localDate.getMonth(), localDate.getDay(), 0, 0).toDate();
            } else {
                date = new DateTime(dateObject).toDate();
            }
            RegularTimePeriod period = RegularTimePeriod.createInstance((Class)this.timePeriodClass, (Date)date, (TimeZone)this.timeZone);
            this.incrementMap(this.resolvedMap, period);
        }

        private void incrementMap(Map<RegularTimePeriod, Number> map, RegularTimePeriod period) {
            Number count = map.get(period);
            if (count == null) {
                count = 0;
            }
            map.put(period, count.intValue() + 1);
        }
    }
}

