/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.whitelist;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.whitelist.WhitelistManager;
import com.atlassian.jira.bc.whitelist.WhitelistService;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import java.net.URI;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class DefaultWhitelistService
implements WhitelistService {
    private final PermissionManager permissionManager;
    private final WhitelistManager whitelistManager;
    private final I18nHelper.BeanFactory beanFactory;

    public DefaultWhitelistService(PermissionManager permissionManager, WhitelistManager whitelistManager, I18nHelper.BeanFactory beanFactory) {
        this.permissionManager = permissionManager;
        this.whitelistManager = whitelistManager;
        this.beanFactory = beanFactory;
    }

    public WhitelistService.WhitelistResult getRules(JiraServiceContext context) {
        Assertions.notNull((String)"context", (Object)context);
        if (this.checkInvalidPermissions(context)) {
            return new WhitelistService.WhitelistResult(context.getErrorCollection());
        }
        return new WhitelistService.WhitelistResult(context.getErrorCollection(), this.whitelistManager.getRules());
    }

    public WhitelistService.WhitelistUpdateValidationResult validateUpdateRules(JiraServiceContext context, List<String> rules, boolean disabled) {
        Assertions.notNull((String)"context", (Object)context);
        Assertions.notNull((String)"rules", rules);
        if (this.checkInvalidPermissions(context)) {
            return new WhitelistService.WhitelistUpdateValidationResult(context.getErrorCollection());
        }
        for (String rule : rules) {
            if (!rule.startsWith("/")) continue;
            try {
                Pattern.compile(rule.substring("/".length()));
            }
            catch (PatternSyntaxException e) {
                I18nHelper i18n = this.beanFactory.getInstance(context.getLoggedInUser());
                context.getErrorCollection().addErrorMessage(i18n.getText("whitelist.admin.errors.bad.pattern", e.getMessage()));
            }
        }
        return new WhitelistService.WhitelistUpdateValidationResult(context.getErrorCollection(), rules, disabled);
    }

    public WhitelistService.WhitelistResult updateRules(WhitelistService.WhitelistUpdateValidationResult result) {
        Assertions.notNull((String)"result", (Object)result);
        if (!result.isValid()) {
            throw new IllegalStateException("Validation result has to be valid!");
        }
        return new WhitelistService.WhitelistResult((ErrorCollection)new SimpleErrorCollection(), this.whitelistManager.updateRules(result.getRules(), result.getDisabled()));
    }

    public boolean isDisabled() {
        return this.whitelistManager.isDisabled();
    }

    public boolean isAllowed(URI uri) {
        Assertions.notNull((String)"uri", (Object)uri);
        return this.whitelistManager.isAllowed(uri);
    }

    boolean checkInvalidPermissions(JiraServiceContext context) {
        if (!this.permissionManager.hasPermission(44, context.getLoggedInUser())) {
            I18nHelper i18n = this.beanFactory.getInstance(context.getLoggedInUser());
            context.getErrorCollection().addErrorMessage(i18n.getText("whitelist.service.permission.error"));
            return true;
        }
        return false;
    }
}

