/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.customfield;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.customfield.CreateValidationResult;
import com.atlassian.jira.bc.customfield.CustomFieldDefinition;
import com.atlassian.jira.bc.customfield.CustomFieldService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.context.manager.JiraContextTreeManager;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.ofbiz.GenericValueUtils;
import com.atlassian.jira.web.action.admin.customfields.CustomFieldContextConfigHelper;
import com.atlassian.jira.web.action.admin.customfields.CustomFieldValidator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultCustomFieldService
implements CustomFieldService {
    private static final String CUSTOMFIELD_PREFIX = "customfield_";
    private static final String NONE_VALUE = "-1";
    private final GlobalPermissionManager permissionManager;
    private final CustomFieldManager customFieldManager;
    private final PermissionSchemeManager permissionSchemeManager;
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;
    private final CustomFieldValidator customFieldValidator;
    private final I18nHelper.BeanFactory i18nFactory;
    private final JiraContextTreeManager treeManager;
    private final CustomFieldContextConfigHelper customFieldContextConfigHelper;
    private final ReindexMessageManager reindexMessageManager;
    private final ConstantsManager constantManager;

    public DefaultCustomFieldService(GlobalPermissionManager permissionManager, CustomFieldManager customFieldManager, PermissionSchemeManager permissionSchemeManager, IssueSecuritySchemeManager issueSecuritySchemeManager, CustomFieldValidator customFieldValidator, I18nHelper.BeanFactory i18nFactory, JiraContextTreeManager treeManager, CustomFieldContextConfigHelper customFieldContextConfigHelper, ReindexMessageManager reindexMessageManager, ConstantsManager constantManager) {
        this.permissionManager = permissionManager;
        this.customFieldManager = customFieldManager;
        this.permissionSchemeManager = permissionSchemeManager;
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
        this.customFieldValidator = customFieldValidator;
        this.i18nFactory = i18nFactory;
        this.treeManager = treeManager;
        this.customFieldContextConfigHelper = customFieldContextConfigHelper;
        this.reindexMessageManager = reindexMessageManager;
        this.constantManager = constantManager;
    }

    public void validateDelete(JiraServiceContext jiraServiceContext, Long customFieldId) {
        I18nHelper i18nBean = jiraServiceContext.getI18nBean();
        if (!this.permissionManager.hasPermission(0, jiraServiceContext.getLoggedInUser())) {
            jiraServiceContext.getErrorCollection().addErrorMessage(i18nBean.getText("admin.customfields.service.no.admin.permission"));
            return;
        }
        CustomField customField = this.customFieldManager.getCustomFieldObject(customFieldId);
        if (customField == null) {
            jiraServiceContext.getErrorCollection().addErrorMessage(i18nBean.getText("admin.errors.customfields.invalid.custom.field"));
            return;
        }
        this.validateNotUsedInPermissionSchemes(jiraServiceContext, customFieldId, false);
    }

    public void validateUpdate(JiraServiceContext jiraServiceContext, Long customFieldId, String name, String description, String searcherKey) {
        if (customFieldId == null) {
            throw new IllegalArgumentException("customFieldId can not be null.");
        }
        I18nHelper i18nBean = jiraServiceContext.getI18nBean();
        if (!this.permissionManager.hasPermission(0, jiraServiceContext.getLoggedInUser())) {
            jiraServiceContext.getErrorCollection().addErrorMessage(i18nBean.getText("admin.customfields.service.no.admin.permission"));
            return;
        }
        CustomField originalCustomField = this.customFieldManager.getCustomFieldObject(customFieldId);
        if (originalCustomField == null) {
            jiraServiceContext.getErrorCollection().addErrorMessage(i18nBean.getText("admin.errors.customfields.invalid.custom.field"));
            return;
        }
        if (StringUtils.isEmpty((String)name)) {
            jiraServiceContext.getErrorCollection().addError("name", i18nBean.getText("admin.errors.customfields.no.name"));
            return;
        }
        if (StringUtils.isNotEmpty((String)searcherKey) && !NONE_VALUE.equals(searcherKey) && this.customFieldManager.getCustomFieldSearcher(searcherKey) == null) {
            jiraServiceContext.getErrorCollection().addError("searcher", i18nBean.getText("admin.errors.customfields.invalid.searcher"));
            return;
        }
        if (StringUtils.isEmpty((String)searcherKey) || NONE_VALUE.equals(searcherKey)) {
            this.validateNotUsedInPermissionSchemes(jiraServiceContext, customFieldId, true);
        }
    }

    void validateNotUsedInPermissionSchemes(JiraServiceContext jiraServiceContext, Long customFieldId, boolean forUpdate) {
        Set<GenericValue> usedIssueLevelSecuritySchemes;
        I18nHelper i18nBean = jiraServiceContext.getI18nBean();
        Set<GenericValue> usedPermissionSchemes = this.getUsedPermissionSchemes(customFieldId);
        if (!usedPermissionSchemes.isEmpty()) {
            String messageKey = forUpdate ? "admin.errors.customfields.used.in.permission.scheme.update" : "admin.errors.customfields.used.in.permission.scheme.delete";
            jiraServiceContext.getErrorCollection().addErrorMessage(i18nBean.getText(messageKey, GenericValueUtils.getCommaSeparatedList(usedPermissionSchemes, (String)"name")));
        }
        if (!(usedIssueLevelSecuritySchemes = this.getUsedIssueSecuritySchemes(customFieldId)).isEmpty()) {
            String messageKey = forUpdate ? "admin.errors.customfields.used.in.issuelevelschemes.update" : "admin.errors.customfields.used.in.issuelevelschemes.delete";
            jiraServiceContext.getErrorCollection().addErrorMessage(i18nBean.getText(messageKey, GenericValueUtils.getCommaSeparatedList(usedIssueLevelSecuritySchemes, (String)"name")));
        }
    }

    public CreateValidationResult validateCreate(User user, CustomFieldDefinition customFieldDefinition) {
        return this.validateCreateImpl(user, customFieldDefinition);
    }

    private CreateValidationResult validateCreateImpl(User user, CustomFieldDefinition customFieldDefinition) {
        List returnIssueTypes;
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        I18nHelper i18nBean = this.i18nFactory.getInstance(user);
        if (user == null || !this.permissionManager.hasPermission(0, user)) {
            errorCollection.addErrorMessage(i18nBean.getText("admin.customfields.service.no.admin.permission"));
            return new CreateValidationResult((ErrorCollection)errorCollection);
        }
        errorCollection.addErrorCollection(this.customFieldValidator.validateType(customFieldDefinition.getCfType()));
        errorCollection.addErrorCollection(this.customFieldValidator.validateDetails(customFieldDefinition.getName(), customFieldDefinition.getCfType(), customFieldDefinition.getSearcherKey()));
        if (!customFieldDefinition.isGlobal() && customFieldDefinition.getProjectIds().isEmpty()) {
            errorCollection.addError("projects", i18nBean.getText("admin.errors.must.select.project.for.non.global.contexts"));
            return new CreateValidationResult((ErrorCollection)errorCollection);
        }
        List projects = customFieldDefinition.getProjectIds();
        List contexts = CustomFieldUtils.buildJiraIssueContexts((boolean)customFieldDefinition.isGlobal(), (Long[])new Long[0], (Long[])projects.toArray(new Long[projects.size()]), (JiraContextTreeManager)this.treeManager);
        if (customFieldDefinition.isAllIssueTypes()) {
            returnIssueTypes = Lists.newArrayList();
            returnIssueTypes.add(null);
        } else {
            List issueTypesIds = customFieldDefinition.getIssueTypeIds();
            returnIssueTypes = CustomFieldUtils.buildIssueTypes((ConstantsManager)this.constantManager, (String[])issueTypesIds.toArray(new String[issueTypesIds.size()]));
        }
        CustomFieldSearcher customFieldSearcher = this.customFieldManager.getCustomFieldSearcher(customFieldDefinition.getSearcherKey());
        CustomFieldType customFieldType = this.customFieldManager.getCustomFieldType(customFieldDefinition.getCfType());
        return new CreateValidationResult((ErrorCollection)errorCollection).user(user).cfType(customFieldType).name(customFieldDefinition.getName()).description(customFieldDefinition.getDescription()).searcher(customFieldSearcher).contextNodes(contexts).issueTypes(returnIssueTypes);
    }

    public ServiceOutcome<CustomField> create(CreateValidationResult createValidationResult) {
        CustomField customField;
        try {
            customField = this.customFieldManager.createCustomField(createValidationResult.getName(), createValidationResult.getDescription(), createValidationResult.getCfType(), createValidationResult.getSearcher(), createValidationResult.getContextNodes(), createValidationResult.getIssueTypes());
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        if (this.customFieldContextConfigHelper.doesAddingContextToCustomFieldAffectIssues(createValidationResult.getUser(), customField, createValidationResult.getContextNodes(), createValidationResult.getIssueTypes(), true)) {
            this.reindexMessageManager.pushMessage(createValidationResult.getUser(), "admin.notifications.task.custom.fields");
        }
        return ServiceOutcomeImpl.ok(customField);
    }

    @VisibleForTesting
    Set<GenericValue> getUsedPermissionSchemes(Long customFieldId) {
        HashSet<GenericValue> ret = new HashSet<GenericValue>();
        ret.addAll(this.permissionSchemeManager.getSchemesContainingEntity("userCF", CUSTOMFIELD_PREFIX + customFieldId));
        ret.addAll(this.permissionSchemeManager.getSchemesContainingEntity("groupCF", CUSTOMFIELD_PREFIX + customFieldId));
        return ret;
    }

    @VisibleForTesting
    Set<GenericValue> getUsedIssueSecuritySchemes(Long customFieldId) {
        HashSet<GenericValue> ret = new HashSet<GenericValue>();
        ret.addAll(this.issueSecuritySchemeManager.getSchemesContainingEntity("userCF", CUSTOMFIELD_PREFIX + customFieldId));
        ret.addAll(this.issueSecuritySchemeManager.getSchemesContainingEntity("groupCF", CUSTOMFIELD_PREFIX + customFieldId));
        return ret;
    }
}

