/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.association;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.association.UserAssociationStore;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.dbc.Assertions;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class UserAssociationStoreImpl
implements UserAssociationStore {
    private final OfBizDelegator ofBizDelegator;
    private UserManager userManager;

    public UserAssociationStoreImpl(OfBizDelegator ofBizDelegator, UserManager userManager) {
        this.ofBizDelegator = ofBizDelegator;
        this.userManager = userManager;
    }

    @Override
    public void createAssociation(String associationType, User user, GenericValue sink) {
        this.createAssociation(associationType, user.getName(), sink.getEntityName(), sink.getLong("id"));
    }

    @Override
    public void createAssociation(String associationType, String userName, String sinkNodeEntity, Long sinkNodeId) {
        GenericValue association = this.getAssociation(userName, sinkNodeId, sinkNodeEntity, associationType);
        if (association == null) {
            FieldMap fields = FieldMap.build((String)"associationType", (Object)associationType).add("sourceName", (Object)userName).add("sinkNodeEntity", (Object)sinkNodeEntity).add("sinkNodeId", (Object)sinkNodeId).add("created", (Object)new Timestamp(System.currentTimeMillis()));
            GenericValue genericValue = this.ofBizDelegator.makeValue("UserAssociation");
            genericValue.setFields((Map)fields);
            try {
                genericValue.create();
            }
            catch (GenericEntityException e) {
                throw new DataAccessException((Throwable)e);
            }
        }
    }

    @Override
    public void removeAssociation(String associationType, User user, GenericValue sink) {
        this.removeAssociation(associationType, user.getName(), sink);
    }

    @Override
    public void removeAssociation(String associationType, String username, GenericValue sink) {
        FieldMap fields = new FieldMap();
        fields.put((Object)"sinkNodeId", (Object)sink.getLong("id"));
        fields.put((Object)"sinkNodeEntity", (Object)sink.getEntityName());
        fields.put((Object)"sourceName", (Object)username);
        fields.put((Object)"associationType", (Object)associationType);
        this.ofBizDelegator.removeByAnd("UserAssociation", (Map)fields);
    }

    @Override
    public void removeUserAssociationsFromUser(String associationType, User user, String sinkNodeEntity) {
        FieldMap fields = new FieldMap();
        fields.put((Object)"sourceName", (Object)user.getName());
        fields.put((Object)"associationType", (Object)associationType);
        fields.put((Object)"sinkNodeEntity", (Object)sinkNodeEntity);
        this.ofBizDelegator.removeByAnd("UserAssociation", (Map)fields);
    }

    @Override
    public void removeUserAssociationsFromSink(String sinkNodeEntity, Long sinkNodeId) {
        FieldMap fields = new FieldMap();
        fields.put((Object)"sinkNodeEntity", (Object)sinkNodeEntity);
        fields.put((Object)"sinkNodeId", (Object)sinkNodeId);
        this.ofBizDelegator.removeByAnd("UserAssociation", (Map)fields);
    }

    @Override
    public boolean associationExists(String associationType, User user, GenericValue sink) {
        return this.associationExists(associationType, user, sink.getEntityName(), sink.getLong("id"));
    }

    @Override
    public boolean associationExists(String associationType, User user, String sinkNodeEntity, Long sinkNodeId) {
        return user != null && this.ofBizDelegator.findByAnd("UserAssociation", this.fieldMap(associationType, user.getName(), sinkNodeEntity, sinkNodeId)).size() > 0;
    }

    @Override
    public List<User> getUsersFromSink(String associationType, GenericValue sink) {
        if (sink == null) {
            throw new IllegalArgumentException("Sink GenericValue can not be null.");
        }
        FieldMap fields = new FieldMap();
        fields.put((Object)"associationType", (Object)associationType);
        fields.put((Object)"sinkNodeEntity", (Object)sink.getEntityName());
        fields.put((Object)"sinkNodeId", (Object)sink.getLong("id"));
        List<GenericValue> results = this.getAssociations((Map<String, ?>)fields);
        ArrayList<User> outList = new ArrayList<User>(results.size());
        for (GenericValue result : results) {
            outList.add(this.userManager.getUser(result.getString("sourceName")));
        }
        return outList;
    }

    @Override
    public List<String> getUsernamesFromSink(String associationType, GenericValue sink) {
        if (sink == null) {
            throw new IllegalArgumentException("Sink GenericValue can not be null.");
        }
        FieldMap fields = new FieldMap();
        fields.put((Object)"associationType", (Object)associationType);
        fields.put((Object)"sinkNodeEntity", (Object)sink.getEntityName());
        fields.put((Object)"sinkNodeId", (Object)sink.getLong("id"));
        List<GenericValue> results = this.getAssociations((Map<String, ?>)fields);
        ArrayList<String> outList = new ArrayList<String>(results.size());
        for (GenericValue result : results) {
            outList.add(result.getString("sourceName"));
        }
        return outList;
    }

    @Override
    public List<GenericValue> getSinksFromUser(String associationType, User user, String sinkNodeEntity) {
        List<GenericValue> associations = this.getAssociationsForUser(associationType, user, sinkNodeEntity);
        ArrayList<GenericValue> sinks = new ArrayList<GenericValue>(associations.size());
        for (GenericValue association : associations) {
            GenericValue sink = this.ofBizDelegator.findByPrimaryKey(sinkNodeEntity, association.getLong("sinkNodeId"));
            if (sink == null) continue;
            sinks.add(sink);
        }
        return sinks;
    }

    private List<GenericValue> getAssociationsForUser(String associationType, User user, String sinkNodeEntity) {
        Assertions.notNull((String)"user", (Object)user);
        FieldMap fields = new FieldMap();
        fields.put((Object)"associationType", (Object)associationType);
        fields.put((Object)"sourceName", (Object)user.getName());
        fields.put((Object)"sinkNodeEntity", (Object)sinkNodeEntity);
        return this.getAssociations((Map<String, ?>)fields);
    }

    private List<GenericValue> getAssociations(Map<String, ?> fields) {
        return this.ofBizDelegator.findByAnd("UserAssociation", fields);
    }

    private Map<String, ?> fieldMap(String associationType, String userName, String sinkNodeEntity, Long sinkNodeId) {
        return FieldMap.build((String)"associationType", (Object)associationType).add("sourceName", (Object)userName).add("sinkNodeEntity", (Object)sinkNodeEntity).add("sinkNodeId", (Object)sinkNodeId);
    }

    private GenericValue getAssociation(String userName, Long sinkNodeId, String sinkNodeEntity, String associationType) {
        FieldMap fields = FieldMap.build((String)"associationType", (Object)associationType).add("sourceName", (Object)userName).add("sinkNodeEntity", (Object)sinkNodeEntity).add("sinkNodeId", (Object)sinkNodeId);
        return EntityUtil.getOnly((List)this.ofBizDelegator.findByAnd("UserAssociation", (Map)fields));
    }
}

