/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.bc.issue.issuelink.IssueLinkService;
import com.atlassian.jira.config.component.ProfilingComponentAdapterFactory;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.collect.MultiMap;
import com.atlassian.jira.util.collect.MultiMaps;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.plugin.osgi.hostcomponents.ComponentRegistrar;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentProvider;
import com.atlassian.sal.api.ApplicationProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.defaults.ComponentAdapterFactory;
import org.picocontainer.defaults.ComponentParameter;
import org.picocontainer.defaults.DefaultPicoContainer;

class ComponentContainer {
    private final DefaultPicoContainer container = new DefaultPicoContainer((ComponentAdapterFactory)new ProfilingComponentAdapterFactory());
    private final Registry registry = new Registry();

    ComponentContainer() {
    }

    MutablePicoContainer getPicoContainer() {
        return this.container;
    }

    ComponentAdapter getComponentAdapter(Class<?> key) {
        return this.container.getComponentAdapter(key);
    }

    <T> T getComponentInstance(Class<T> key) {
        ComponentAdapter adapter = this.getComponentAdapter(key);
        return key.cast(adapter.getComponentInstance());
    }

    HostComponentProvider getHostComponentProvider() {
        return new HostComponentProviderImpl(this.registry);
    }

    void instance(Scope scope, Object instance) {
        scope.get(this.registry).register(instance.getClass());
        this.container.registerComponentInstance(instance);
    }

    void instance(Scope scope, String key, Object instance) {
        scope.get(this.registry).register(instance.getClass());
        this.container.registerComponentInstance((Object)key, instance);
    }

    <T, S extends T> void instance(Scope scope, Class<T> key, S instance) {
        scope.get(this.registry).register(key);
        this.container.registerComponentInstance(key, instance);
    }

    void implementation(Scope scope, Class<?> implementation) {
        scope.get(this.registry).register(implementation);
        this.container.registerComponentImplementation(implementation);
    }

    <T> void implementation(Scope scope, Class<? super T> key, Class<T> implementation) {
        scope.get(this.registry).register(key);
        this.container.registerComponentImplementation(key, implementation);
    }

    <T> void implementation(Scope scope, Class<? super T> key, Class<T> implementation, Object ... parameterKeys) {
        Parameter[] componentParameters = new Parameter[parameterKeys.length];
        for (int i = 0; i < parameterKeys.length; ++i) {
            Object parameter = parameterKeys[i];
            componentParameters[i] = parameter instanceof Parameter ? (Parameter)parameter : new ComponentParameter(parameter);
        }
        this.implementation(scope, key, implementation, componentParameters);
    }

    <T> void implementation(Scope scope, Class<? super T> key, Class<T> implementation, Parameter[] parameters) {
        scope.get(this.registry).register(key);
        this.container.registerComponentImplementation(key, implementation, parameters);
    }

    <T> void implementationUseDefaultConstructor(Scope scope, Class<T> key, Class<? extends T> implementation) {
        scope.get(this.registry).register(key);
        this.container.registerComponentImplementation(key, implementation, Collections.EMPTY_LIST);
    }

    void transfer(ComponentManager from, Scope scope, Class<?> key) {
        this.instance(scope, key, key.cast(from.getContainer().getComponentInstance(key)));
    }

    void component(Scope scope, ComponentAdapter componentAdapter) {
        scope.get(this.registry).register(componentAdapter);
        this.container.registerComponent(componentAdapter);
    }

    static String extractSpringLikeBeanNameFromInterface(Set<String> usedKeys, Class<?> clazz) {
        Assertions.notNull((String)"clazz", clazz);
        String hardCodedKey = ComponentContainer.mapDuplicates(clazz);
        if (hardCodedKey != null) {
            return hardCodedKey;
        }
        String className = clazz.getSimpleName();
        String calculatedKey = className.substring(0, 1).toLowerCase(Locale.ENGLISH) + className.substring(1);
        if (usedKeys.contains(calculatedKey)) {
            throw new IllegalStateException("Duplicate component key found for '" + calculatedKey + "'.");
        }
        return calculatedKey;
    }

    private static String mapDuplicates(Class<?> clazz) {
        if (clazz.equals(ApplicationProperties.class)) {
            return "salApplicationProperties";
        }
        if (clazz.equals(IssueLinkService.class)) {
            return "oldIssueLinkService";
        }
        if (clazz.equals(I18nHelper.class)) {
            return "contextI18nHelper";
        }
        return null;
    }

    private static final class Component {
        private final Object instance;
        private final Set<Class<?>> interfaces;

        Component(Object instance, Set<Class<?>> interfaces) {
            this.instance = Assertions.notNull((String)"instance", (Object)instance);
            this.interfaces = Collections.unmodifiableSet(new HashSet((Collection)Assertions.notNull((String)"interfaces", interfaces)));
        }

        public Object getInstance() {
            return this.instance;
        }

        public Class<?>[] getInterfaces() {
            return this.interfaces.toArray(new Class[this.interfaces.size()]);
        }

        public int hashCode() {
            return this.instance.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Component) {
                return this.instance == ((Component)obj).instance;
            }
            return false;
        }
    }

    private class Registry {
        private final Set<Class<?>> availableComponents = new HashSet();

        private Registry() {
        }

        void register(Class<?> componentKey) {
            if (!componentKey.isInterface()) {
                throw new IllegalArgumentException(componentKey + " must be an interface to provide to plugins.");
            }
            if (this.availableComponents.contains(componentKey)) {
                throw new IllegalArgumentException(componentKey + " has already been provided.");
            }
            this.availableComponents.add(componentKey);
        }

        void register(ComponentAdapter componentAdapter) {
            Object key = componentAdapter.getComponentKey();
            if (key instanceof Class) {
                this.register((Class)key);
            }
        }

        Set<Component> getComponents() {
            MultiMap instances = MultiMaps.create((Supplier)new Supplier<Set<Class<?>>>(){

                public Set<Class<?>> get() {
                    return new HashSet();
                }
            });
            for (Class<?> exposedInterface : this.availableComponents) {
                Object instance = ComponentContainer.this.getComponentInstance(exposedInterface);
                if (instance == null) continue;
                instances.putSingle(instance, exposedInterface);
            }
            HashSet<Component> result = new HashSet<Component>();
            for (Map.Entry entry : instances.entrySet()) {
                result.add(new Component(entry.getKey(), (Set)entry.getValue()));
            }
            return Collections.unmodifiableSet(result);
        }
    }

    static class HostComponentProviderImpl
    implements HostComponentProvider {
        private final Registry registry;

        HostComponentProviderImpl(Registry registry) {
            this.registry = registry;
        }

        public void provide(ComponentRegistrar registrar) {
            Set<Component> components = this.registry.getComponents();
            HashSet<String> usedKeys = new HashSet<String>();
            for (Component component : components) {
                Class<?>[] interfaces;
                for (Class<?> iface : interfaces = component.getInterfaces()) {
                    String name = ComponentContainer.extractSpringLikeBeanNameFromInterface(usedKeys, iface);
                    registrar.register(new Class[]{iface}).forInstance(component.getInstance()).withName(name);
                    usedKeys.add(name);
                }
            }
        }
    }

    static enum Scope {
        PROVIDED{

            @Override
            Registrar get(final Registry registry) {
                return new Registrar(){

                    @Override
                    public void register(Class<?> klass) {
                        registry.register(klass);
                    }

                    @Override
                    public void register(ComponentAdapter adapter) {
                        registry.register(adapter);
                    }
                };
            }
        }
        ,
        INTERNAL{

            @Override
            Registrar get(Registry registry) {
                return new Registrar(){

                    @Override
                    public void register(Class<?> klass) {
                    }

                    @Override
                    public void register(ComponentAdapter adapter) {
                    }
                };
            }
        };


        abstract Registrar get(Registry var1);

        static interface Registrar {
            public void register(Class<?> var1);

            public void register(ComponentAdapter var1);
        }
    }
}

