/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webwork.parameters;

import com.atlassian.jira.webwork.parameters.AbstractParameterConverter;
import com.atlassian.jira.webwork.parameters.IntegerConverter;

public class IntegerArrayConverter
extends AbstractParameterConverter {
    private final IntegerConverter converter = new IntegerConverter();

    @Override
    public Object convertParameter(String[] parameterValues, Class paramType) throws IllegalArgumentException {
        Integer[] convertedValues = new Integer[parameterValues.length];
        for (int i = 0; i < parameterValues.length; ++i) {
            convertedValues[i] = this.converter.convert(parameterValues[i], paramType.getComponentType());
        }
        if (paramType.getComponentType().isPrimitive()) {
            return this.convertToPrimitive(convertedValues);
        }
        return convertedValues;
    }

    private Object convertToPrimitive(Integer[] convertedValues) {
        int[] primtiveArr = new int[convertedValues.length];
        for (int i = 0; i < convertedValues.length; ++i) {
            primtiveArr[i] = convertedValues[i];
        }
        return primtiveArr;
    }
}

