/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.util;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.worklog.WorkRatio;
import java.util.Collection;
import java.util.LinkedList;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class IssueTableBean {
    private final SubTaskManager subTaskManager = ComponentAccessor.getSubTaskManager();
    private final IssueManager issueManager = ComponentAccessor.getIssueManager();

    public GenericValue getSecurityLevel(GenericValue issue) throws Exception {
        if (issue == null) {
            throw new IllegalArgumentException("Issue cannot be null.");
        }
        IssueSecurityLevelManager secur = ComponentAccessor.getIssueSecurityLevelManager();
        return secur.getIssueSecurity(issue.getLong("security"));
    }

    public Collection getFixVersions(GenericValue issue) throws GenericEntityException {
        if (issue == null) {
            throw new IllegalArgumentException("Issue cannot be null.");
        }
        return ComponentAccessor.getIssueManager().getEntitiesByIssue("IssueFixVersion", issue);
    }

    public Collection getVersions(GenericValue issue) throws GenericEntityException {
        if (issue == null) {
            throw new IllegalArgumentException("Issue cannot be null.");
        }
        return ComponentAccessor.getIssueManager().getEntitiesByIssue("IssueVersion", issue);
    }

    public Collection getComponents(GenericValue issue) throws GenericEntityException {
        if (issue == null) {
            throw new IllegalArgumentException("Issue cannot be null.");
        }
        return ComponentAccessor.getIssueManager().getEntitiesByIssue("IssueComponent", issue);
    }

    public long getWorkRatio(GenericValue issue) {
        return WorkRatio.getWorkRatio((GenericValue)issue);
    }

    public String getPaddedWorkRatio(GenericValue issue) {
        return WorkRatio.getPaddedWorkRatio((GenericValue)issue);
    }

    public boolean isWorkEstimateExists(GenericValue issue) {
        return issue.get("timeoriginalestimate") != null;
    }

    public String getParentIssueKey(Issue issue) throws GenericEntityException {
        return this.getParentIssueKey(issue.getGenericValue());
    }

    public String getParentIssueKey(GenericValue issue) throws GenericEntityException {
        MutableIssue parentIssue;
        Long parentIssueId = this.subTaskManager.getParentIssueId(issue);
        if (parentIssueId != null && (parentIssue = this.issueManager.getIssueObject(parentIssueId)) != null) {
            return parentIssue.getKey();
        }
        return null;
    }

    public String getParentIssueSummary(Issue issue) throws GenericEntityException {
        return this.getParentIssueSummary(issue.getGenericValue());
    }

    public String getParentIssueSummary(GenericValue issue) throws GenericEntityException {
        MutableIssue parentIssue;
        Long parentIssueId = this.subTaskManager.getParentIssueId(issue);
        if (parentIssueId != null && (parentIssue = this.issueManager.getIssueObject(parentIssueId)) != null) {
            return parentIssue.getSummary();
        }
        return null;
    }

    public Collection getSubTasks(GenericValue issue) {
        LinkedList<GenericValue> subTaskIssues = new LinkedList<GenericValue>();
        for (IssueLink issueLink : this.subTaskManager.getSubTaskIssueLinks(issue.getLong("id"))) {
            subTaskIssues.add(issueLink.getDestinationObject().getGenericValue());
        }
        return subTaskIssues;
    }
}

