/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.util;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.web.util.AuthorizationSupport;
import org.ofbiz.core.entity.GenericValue;

public class DefaultAuthorizationSupport
implements AuthorizationSupport {
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public DefaultAuthorizationSupport(PermissionManager permissionManager, JiraAuthenticationContext jiraAuthenticationContext) {
        this.permissionManager = permissionManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public boolean isHasPermission(String permName) {
        return this.isHasPermission(Permissions.getType((String)permName));
    }

    public boolean isHasPermission(int permissionsId) {
        return this.permissionManager.hasPermission(permissionsId, this.jiraAuthenticationContext.getLoggedInUser());
    }

    public boolean isHasIssuePermission(String permName, GenericValue issue) {
        return this.isHasIssuePermission(Permissions.getType((String)permName), issue);
    }

    public boolean isHasIssuePermission(int permissionsId, GenericValue issue) {
        if (issue == null) {
            throw new IllegalArgumentException("isHasIssuePermission can not be passed a null issue");
        }
        if (!"Issue".equals(issue.getEntityName())) {
            throw new IllegalArgumentException("isHasIssuePermission can only take an Issue: " + issue.getEntityName() + " is not.");
        }
        return this.permissionManager.hasPermission(permissionsId, issue, this.jiraAuthenticationContext.getLoggedInUser());
    }

    public boolean isHasProjectPermission(String permName, GenericValue project) {
        return this.isHasProjectPermission(Permissions.getType((String)permName), project);
    }

    public boolean isHasProjectPermission(int permissionsId, GenericValue project) {
        if (project == null) {
            throw new IllegalArgumentException("isHasProjectPermission can not be passed a null project");
        }
        if (!"Project".equals(project.getEntityName())) {
            throw new IllegalArgumentException("isHasProjectPermission can only take a Project: " + project.getEntityName() + " is not.");
        }
        return this.permissionManager.hasPermission(permissionsId, project, this.jiraAuthenticationContext.getLoggedInUser());
    }

    @Deprecated
    public boolean isHasPermission(String permName, GenericValue entity) {
        return this.permissionManager.hasPermission(Permissions.getType((String)permName), entity, this.jiraAuthenticationContext.getLoggedInUser());
    }
}

