/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.gzip;

import com.atlassian.gzipfilter.GzipFilter;
import com.atlassian.gzipfilter.integration.GzipFilterIntegration;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.CoreFeatures;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class JiraGzipFilter
extends GzipFilter {
    private static final Logger log = Logger.getLogger(JiraGzipFilter.class);

    public JiraGzipFilter() {
        super(JiraGzipFilter.createGzipIntegration());
    }

    private static GzipFilterIntegration createGzipIntegration() {
        if (CoreFeatures.ON_DEMAND.isSystemPropertyEnabled()) {
            return new JiraOnDemandGzipFilterIntegration();
        }
        return new JiraGzipFilterIntegration();
    }

    private static class JiraOnDemandGzipFilterIntegration
    extends JiraGzipFilterIntegration {
        private JiraOnDemandGzipFilterIntegration() {
        }

        @Override
        public boolean useGzip() {
            return false;
        }
    }

    private static class JiraGzipFilterIntegration
    implements GzipFilterIntegration {
        private JiraGzipFilterIntegration() {
        }

        public boolean useGzip() {
            try {
                return ComponentAccessor.getApplicationProperties().getOption("jira.option.web.usegzip");
            }
            catch (RuntimeException e) {
                log.debug((Object)"Cannot get application properties, defaulting to no GZip compression");
                return false;
            }
        }

        public String getResponseEncoding(HttpServletRequest httpServletRequest) {
            return ComponentAccessor.getApplicationProperties().getEncoding();
        }
    }
}

