/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.admin.user.UserPasswordActionHelper;
import org.apache.commons.lang.StringUtils;
import webwork.action.ResultException;

public class ResetPassword
extends JiraWebActionSupport {
    private final UserUtil userUtil;
    private String token;
    private String os_username;
    private String password;
    private String confirm;
    private User userInPlay;
    private boolean tokenTimedOut;
    private boolean tokenInvalid;

    public ResetPassword(UserUtil userUtil) {
        this.userUtil = userUtil;
    }

    public String doDefault() {
        this.validateUserAndToken();
        if (this.hasAnyErrors()) {
            return "error";
        }
        return "input";
    }

    protected void validate() throws ResultException {
        this.validateUserAndToken();
        if (!this.tokenInvalid && !this.tokenTimedOut) {
            this.validateNewPasswords();
        }
    }

    protected String doExecute() {
        if (this.tokenInvalid || this.tokenTimedOut || this.invalidInput()) {
            return "error";
        }
        new UserPasswordActionHelper(this, this.userUtil).setPassword(this.userInPlay, this.password);
        if (this.invalidInput()) {
            return "error";
        }
        return "success";
    }

    private void validateUserAndToken() {
        this.userInPlay = this.userUtil.getUser(this.os_username);
        if (this.userInPlay == null) {
            this.addErrorMessage(this.getText("resetpassword.error.unknown.user"));
        } else {
            UserUtil.PasswordResetTokenValidation validation = this.userUtil.validatePasswordResetToken(this.userInPlay, this.token);
            if (validation.getStatus() == UserUtil.PasswordResetTokenValidation.Status.EXPIRED) {
                this.tokenTimedOut = true;
                this.addErrorMessage(this.getText("resetpassword.error.token.timedout"));
            } else if (validation.getStatus() == UserUtil.PasswordResetTokenValidation.Status.UNEQUAL) {
                this.tokenInvalid = true;
                this.addErrorMessage(this.getText("resetpassword.error.invalid.token"));
            }
        }
    }

    private void validateNewPasswords() {
        if (StringUtils.isBlank((String)this.password) || StringUtils.isBlank((String)this.confirm)) {
            this.addErrorMessage(this.getText("resetpassword.error.password.blank"));
        } else if (!this.nvl(this.password, "").equals(this.confirm)) {
            this.addErrorMessage(this.getText("resetpassword.error.password.mustmatch"));
        }
    }

    private String nvl(String str, String defaultStr) {
        return str == null ? defaultStr : str;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getOs_username() {
        return this.os_username;
    }

    public void setOs_username(String os_username) {
        this.os_username = os_username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public boolean isTokenTimedOut() {
        return this.tokenTimedOut;
    }

    public boolean isTokenInvalid() {
        return this.tokenInvalid;
    }
}

