/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.exception.IssueNotFoundException;
import com.atlassian.jira.exception.IssuePermissionException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.issue.AbstractCommentableAssignableIssue;
import com.atlassian.jira.web.bean.MoveIssueBean;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.Action;
import webwork.action.ActionContext;

public class MoveIssue
extends AbstractCommentableAssignableIssue {
    public static final String SUBTASK_STATUS_PREFIX = "subtaskstatus_";
    private static final String SUBTASK_ISSUETYPE_PREFIX = "subtaskissuetype_";
    protected final ConstantsManager constantsManager;
    protected final WorkflowManager workflowManager;
    protected final FieldManager fieldManager;
    protected final FieldLayoutManager fieldLayoutManager;
    protected final IssueFactory issueFactory;

    public MoveIssue(SubTaskManager subTaskManager, ConstantsManager constantsManager, WorkflowManager workflowManager, FieldManager fieldManager, FieldLayoutManager fieldLayoutManager, IssueFactory issueFactory, FieldScreenRendererFactory fieldScreenRendererFactory, CommentService commentService, UserUtil userUtil) {
        super(subTaskManager, fieldScreenRendererFactory, commentService, userUtil);
        this.constantsManager = constantsManager;
        this.workflowManager = workflowManager;
        this.fieldManager = fieldManager;
        this.fieldLayoutManager = fieldLayoutManager;
        this.issueFactory = issueFactory;
    }

    protected String doExecute() throws Exception {
        if (this.getMoveIssueBean() == null) {
            return this.redirectToSessionTimeoutPage();
        }
        if (this.isHasSubTasks()) {
            this.getMoveIssueBean().addAvailablePreviousStep(1);
            return this.forceRedirect("MoveIssueSubtasks!default.jspa?id=" + this.id);
        }
        return this.forceRedirect("MoveIssueUpdateWorkflow!default.jspa?id=" + this.id + "&assignee=" + URLEncoder.encode("" + this.getAssignee(), "UTF8"));
    }

    @Override
    public String doDefault() throws Exception {
        try {
            if (!this.isHasIssuePermission(25, this.getIssue())) {
                return "securitybreach";
            }
        }
        catch (IssueNotFoundException e) {
            return "error";
        }
        catch (IssuePermissionException e) {
            return "error";
        }
        if (ActionContext.getSingleValueParameters().containsKey("reset") && "true".equals(ActionContext.getSingleValueParameters().get("reset")) && this.getMoveIssueBean() != null) {
            Long selectedPid = this.getMoveIssueBean().getTargetPid();
            String selectedIssueTypeId = this.getMoveIssueBean().getTargetIssueType();
            this.getMoveIssueBean().clearAvailablePreviousSteps();
            this.getMoveIssueBean().reset();
            this.getMoveIssueBean().setIssueId(this.getIssue().getLong("id"));
            this.getMoveIssueBean().getFieldValuesHolder().put("project", selectedPid);
            this.getMoveIssueBean().getFieldValuesHolder().put("issuetype", selectedIssueTypeId);
        } else {
            MoveIssueBean moveIssueBean = new MoveIssueBean(this.constantsManager, this.projectManager);
            moveIssueBean.setIssueId(this.getIssue().getLong("id"));
            ActionContext.getSession().put("jira.moveissuebean", moveIssueBean);
            MutableIssue issueObject = this.getIssueObject(this.getIssue());
            this.fieldManager.getProjectField().populateFromIssue(this.getMoveIssueBean().getFieldValuesHolder(), (Issue)issueObject);
            this.fieldManager.getIssueTypeField().populateFromIssue(this.getMoveIssueBean().getFieldValuesHolder(), (Issue)issueObject);
        }
        this.getMoveIssueBean().setCurrentStep(1);
        return "input";
    }

    @Override
    protected void doValidation() {
        if (this.getMoveIssueBean() != null) {
            try {
                if (!this.isHasIssuePermission(25, this.getIssue())) {
                    this.addErrorMessage(this.getText("move.issue.nopermissions"));
                    return;
                }
                this.fieldManager.getProjectField().populateFromParams(this.getMoveIssueBean().getFieldValuesHolder(), ActionContext.getParameters());
                this.fieldManager.getIssueTypeField().populateFromParams(this.getMoveIssueBean().getFieldValuesHolder(), ActionContext.getParameters());
                MutableIssue issueObject = this.getIssueObject(null);
                this.fieldManager.getProjectField().validateParams((OperationContext)this.getMoveIssueBean(), (ErrorCollection)this, (I18nHelper)this, (Issue)issueObject, null);
                this.fieldManager.getIssueTypeField().validateParams((OperationContext)this.getMoveIssueBean(), (ErrorCollection)this, (I18nHelper)this, (Issue)issueObject, null);
                if (this.getIssue().getLong("project").equals(this.getMoveIssueBean().getTargetPid()) && this.getIssue().getString("type").equals(this.getMoveIssueBean().getTargetIssueType())) {
                    this.addErrorMessage(this.getText("move.issue.nochange"));
                }
                if (!this.invalidInput()) {
                    this.validateAttachmentMove();
                    this.validateCreateIssue();
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Exception: " + e), (Throwable)e);
                this.addErrorMessage("An exception occurred: " + e + ".");
            }
        }
    }

    protected String redirectToSessionTimeoutPage() {
        ActionContext.getSession().put("jira.session.timeout.message", this.getText("moveissue.session.timeout.message"));
        return this.getRedirect("SessionTimeoutMessage.jspa");
    }

    protected void validateAttachmentMove() {
        Collection attachments = this.getIssueObject().getAttachments();
        if (!this.isHasProjectPermission(19, this.getTargetProject()) && !attachments.isEmpty()) {
            this.addErrorMessage(this.getText("moveissue.create.attachment.permission"));
        }
    }

    protected void validateCreateIssue() throws GenericEntityException {
        if (!this.isHasProjectPermission(11, this.getTargetProject())) {
            this.addErrorMessage(this.getText("moveissue.no.create.permission"));
        }
    }

    public Long getTargetPid() {
        return this.getMoveIssueBean().getTargetPid();
    }

    public String getTargetStatusId() {
        return this.getMoveIssueBean().getTargetStatusId();
    }

    public GenericValue getTargetProject() {
        return this.getProjectManager().getProject(this.getTargetPid());
    }

    public Project getTargetProjectObj() {
        return this.getProjectManager().getProjectObj(this.getTargetPid());
    }

    public GenericValue getTargetIssueTypeGV() {
        return this.constantsManager.getIssueType(this.getTargetIssueType());
    }

    public IssueType getTargetIssueTypeObject() {
        return this.constantsManager.getIssueTypeObject(this.getTargetIssueType());
    }

    public JiraWorkflow getTargetWorkflow() throws WorkflowException {
        return this.getWorkflowForType(this.getTargetPid(), this.getTargetIssueType());
    }

    public JiraWorkflow getCurrentWorkflow() throws WorkflowException, GenericEntityException {
        return this.getWorkflowForType(this.getProject().getLong("id"), this.getIssue().getString("type"));
    }

    public JiraWorkflow getWorkflowForType(Long projectId, String issueTypeId) throws WorkflowException {
        return this.workflowManager.getWorkflow(projectId, issueTypeId);
    }

    public GenericValue getCurrentStatusGV() {
        return this.constantsManager.getStatus(this.getIssue().getString("status"));
    }

    public String getTargetIssueType() {
        return this.getMoveIssueBean().getTargetIssueType();
    }

    public String getCurrentIssueType() {
        return this.getIssue().getString("type");
    }

    public Collection getAllowedProjects() {
        return ManagerFactory.getPermissionManager().getProjects(11, this.getLoggedInUser());
    }

    @Override
    public boolean isSubTask() {
        return this.getSubTaskManager().isSubTask(this.getIssue());
    }

    public Collection getTargetWorkflowStatuses(String issueTypeId) {
        JiraWorkflow workflow = this.getWorkflowForType(this.getTargetPid(), issueTypeId);
        return workflow.getLinkedStatuses();
    }

    public boolean isWorkflowMatch(String currentIssueTypeId, String targetIssueTypeId) {
        return this.getWorkflowForType(this.getProject().getLong("id"), currentIssueTypeId).equals(this.getWorkflowForType(this.getTargetPid(), targetIssueTypeId));
    }

    public boolean isHasSubTasks() {
        return this.getSubTaskManager().isSubTasksEnabled() && !this.getSubTaskManager().getSubTasks(this.getIssue()).isEmpty();
    }

    public Collection getSubTasks() {
        return this.getSubTaskManager().getSubTasks(this.getIssue());
    }

    public Collection getSubTaskTypesUsed() {
        Collection subTasks = this.getSubTasks();
        HashSet<GenericValue> usedSubTaskTypes = new HashSet<GenericValue>();
        for (GenericValue subTask : subTasks) {
            usedSubTaskTypes.add(this.constantsManager.getIssueType(subTask.getString("type")));
        }
        return usedSubTaskTypes;
    }

    public String getPrefixTaskStatusId(String taskTypeId, String taskStatusId) {
        return SUBTASK_STATUS_PREFIX + taskTypeId + "_" + taskStatusId;
    }

    public String getPrefixIssueTypeId(String issueType) {
        return SUBTASK_ISSUETYPE_PREFIX + issueType;
    }

    public String getSubTaskTargetStatus(String taskTypeId, String taskStatusId) {
        String subTaskTypeKey;
        Map actionParameters = ActionContext.getParameters();
        Object o = actionParameters.get(subTaskTypeKey = SUBTASK_STATUS_PREFIX + taskTypeId + "_" + taskStatusId);
        if (o instanceof String[]) {
            String[] strings = (String[])o;
            return strings[0];
        }
        return null;
    }

    public boolean isStatusChangeRequired() {
        try {
            if (this.isIssueStatusValid()) {
                if (!this.isSubTask() || this.getSubTaskManager().getSubTasks(this.getIssue()).isEmpty()) {
                    return this.isTaskStatusChangeRequired();
                }
                return false;
            }
        }
        catch (WorkflowException e) {
            this.log.error((Object)e, (Throwable)e);
        }
        return true;
    }

    public boolean isTaskStatusChangeRequired() throws WorkflowException {
        Collection types = this.getSubTaskTypesUsed();
        for (GenericValue type : types) {
            if (this.getTaskInvalidStatuses(type.getString("id")).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean isIssueStatusValid() throws WorkflowException {
        String status = this.getIssue().getString("status");
        GenericValue statusGV = this.constantsManager.getStatus(status);
        List availableStatuses = this.getTargetWorkflow().getLinkedStatuses();
        return availableStatuses.contains(statusGV);
    }

    public boolean isTaskStatusValid(String typeId, String statusId) throws WorkflowException {
        JiraWorkflow targetWorkflow = this.getWorkflowForType(this.getTargetPid(), typeId);
        GenericValue statusGV = this.constantsManager.getStatus(statusId);
        List availableStatuses = targetWorkflow.getLinkedStatuses();
        return availableStatuses.contains(statusGV);
    }

    public Collection getTaskInvalidStatuses(String typeId) throws WorkflowException {
        Collection subTasks = this.getSubTasks();
        HashSet<GenericValue> invalidStatuses = new HashSet<GenericValue>();
        for (GenericValue subTask : subTasks) {
            String taskType = subTask.getString("type");
            String taskStatus = subTask.getString("status");
            if (invalidStatuses.contains(taskStatus) || !typeId.equals(taskType)) continue;
            GenericValue subStatusGV = this.constantsManager.getStatus(taskStatus);
            Collection availableStatuses = this.getTargetWorkflowStatuses(taskType);
            if (availableStatuses.contains(subStatusGV)) continue;
            invalidStatuses.add(subStatusGV);
        }
        return invalidStatuses;
    }

    public Collection getTasksWithStatus(String invalidStatusId) throws WorkflowException {
        Collection subTasks = this.getSubTaskManager().getSubTasks(this.getIssue());
        ArrayList<GenericValue> tasksWithStatus = new ArrayList<GenericValue>();
        for (GenericValue subTaskGV : subTasks) {
            if (!subTaskGV.getString("status").equals(invalidStatusId)) continue;
            tasksWithStatus.add(subTaskGV);
        }
        return tasksWithStatus;
    }

    protected FieldLayoutManager getFieldLayoutManager() {
        return this.fieldLayoutManager;
    }

    public ConstantsManager getConstantsManager() {
        return this.constantsManager;
    }

    protected WorkflowManager getWorkflowManager() {
        return this.workflowManager;
    }

    public MoveIssueBean getMoveIssueBean() {
        return (MoveIssueBean)ActionContext.getSession().get("jira.moveissuebean");
    }

    public void setBeanTargetStatusId(String targetStatusId) {
        if (targetStatusId != null) {
            this.getMoveIssueBean().setTargetStatusId(targetStatusId);
        }
    }

    public String getBeanTargetStatusId() {
        return this.getMoveIssueBean().getTargetStatusId();
    }

    public String getFieldHtml(String fieldId) throws Exception {
        return ((OrderableField)this.fieldManager.getField(fieldId)).getCreateHtml(null, (OperationContext)this.getMoveIssueBean(), (Action)this, (Issue)this.getIssueObject(this.getIssue()), this.getViewHtmlParams());
    }

    protected Map getViewHtmlParams() {
        return EasyMap.build((Object)"noHeader", (Object)Boolean.TRUE);
    }

    public MutableIssue getIssueObject(GenericValue issue) {
        return this.issueFactory.getIssue(issue);
    }

    protected FieldManager getFieldManager() {
        return this.fieldManager;
    }

    public String getSubtaskTargetIssueType(String subtaskIssueType) {
        String issueTypeKey = this.getPrefixIssueTypeId(subtaskIssueType);
        return (String)this.getMoveIssueBean().getFieldValuesHolder().get(issueTypeKey);
    }
}

