/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.bc.issue.attachment.AttachmentService;
import com.atlassian.jira.exception.AttachmentNotFoundException;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.issue.AbstractIssueSelectAction;

public class DeleteAttachment
extends AbstractIssueSelectAction {
    private static final String FROM_ISSUE = "issue";
    private final AttachmentService attachmentService;
    private Long deleteAttachmentId;
    private String from;
    private Attachment attachment;

    public DeleteAttachment(AttachmentService attachmentService) {
        this.attachmentService = attachmentService;
    }

    private boolean validateDelete() {
        try {
            this.attachmentService.canDeleteAttachment(this.getJiraServiceContext(), this.deleteAttachmentId);
        }
        catch (AttachmentNotFoundException e) {
            this.addErrorMessage(this.getText("delete.attachment.does.not.exist"));
        }
        return !this.isInError();
    }

    public String doDefault() {
        if (!this.validateDelete()) {
            return "error";
        }
        return "input";
    }

    @RequiresXsrfCheck
    public String doExecute() throws Exception {
        if (!this.validateDelete()) {
            return "error";
        }
        this.attachmentService.delete(this.getJiraServiceContext(), this.deleteAttachmentId);
        if (this.isInError()) {
            return "error";
        }
        return this.returnComplete(this.getNextUrl());
    }

    public String getNextUrl() {
        if (FROM_ISSUE.equals(this.getFrom())) {
            return "/browse/" + this.getIssueObject().getKey();
        }
        return "ManageAttachments.jspa?id=" + this.getIssueId();
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getFrom() {
        return this.from;
    }

    public Long getDeleteAttachmentId() {
        return this.deleteAttachmentId;
    }

    public void setDeleteAttachmentId(Long deleteAttachmentId) {
        this.deleteAttachmentId = deleteAttachmentId;
    }

    public Long getIssueId() {
        return this.getIssueObject().getId();
    }

    public Attachment getAttachment() {
        if (this.attachment == null && !this.isInError()) {
            try {
                this.attachment = this.attachmentService.getAttachment(this.getJiraServiceContext(), this.deleteAttachmentId);
            }
            catch (AttachmentNotFoundException e) {
                this.addErrorMessage(this.getText("delete.attachment.does.not.exist"));
            }
        }
        return this.attachment;
    }

    public boolean isInError() {
        return this.hasAnyErrors() || !this.isIssueValid();
    }
}

