/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.filter;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.favourites.FavouritesService;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.issue.search.util.SearchSortUtil;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharePermissionUtils;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.jira.sharing.type.ShareTypeFactory;
import com.atlassian.jira.sharing.type.ShareTypeRenderer;
import com.atlassian.jira.user.util.UserNames;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.web.action.filter.FilterOperationsAction;
import com.atlassian.jira.web.action.issue.SearchDescriptionEnabledAction;
import com.atlassian.jira.web.bean.ShareTypeRendererBean;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class EditFilter
extends SearchDescriptionEnabledAction
implements FilterOperationsAction {
    private static final String FATAL_ERROR = "fatalerror";
    private String name = null;
    private String description = null;
    private String shareString = null;
    private Long filterId = null;
    private final Set<SharePermission> shares = new HashSet<SharePermission>();
    private Boolean isFavourite = null;
    private final FavouritesService favouritesService;
    private final ShareTypeFactory shareTypeFactory;
    private final JiraAuthenticationContext authCtx;
    private final SearchRequestService searchRequestService;
    private final PermissionManager permissionsManager;

    public EditFilter(IssueSearcherManager issueSearcherManager, SearchRequestService searchRequestService, FavouritesService favouritesService, PermissionManager permissionsManager, JiraAuthenticationContext authCtx, ShareTypeFactory shareTypeFactory, SearchService searchService, SearchSortUtil searchSortUtil) {
        super(issueSearcherManager, searchService, searchSortUtil);
        this.searchRequestService = searchRequestService;
        this.favouritesService = favouritesService;
        this.permissionsManager = permissionsManager;
        this.authCtx = authCtx;
        this.shareTypeFactory = shareTypeFactory;
    }

    public String doDefault() throws Exception {
        SearchRequest searchRequest;
        JiraServiceContext ctx = this.getJiraServiceContext();
        if (this.filterId != null) {
            SearchRequest request = this.searchRequestService.getFilter(ctx, this.filterId);
            if (ctx.getErrorCollection().hasAnyErrors()) {
                return FATAL_ERROR;
            }
            if (request == null) {
                this.addErrorMessage(this.getText("admin.errors.filters.nonexistent"));
                return FATAL_ERROR;
            }
            this.setSearchRequest(request);
        }
        if ((searchRequest = this.getSearchRequest()) == null) {
            this.addErrorMessage(this.getText("admin.errors.filters.no.search.request"));
            return FATAL_ERROR;
        }
        if (!UserNames.equal(searchRequest.getOwnerUserName(), this.getLoggedInUser())) {
            this.addErrorMessage(this.getText("admin.errors.filters.not.owner"));
            return FATAL_ERROR;
        }
        if (searchRequest.isModified()) {
            this.addErrorMessage(this.getText("admin.errors.filters.search.request.updated"));
            return "error";
        }
        if (!this.validateSearchFilterIsSavedFilter(searchRequest, "editfilter.current.filter.not.saved")) {
            return FATAL_ERROR;
        }
        this.setFilterName(searchRequest.getName());
        this.setFilterDescription(searchRequest.getDescription());
        this.setFilterId(searchRequest.getId());
        this.setSharePermissions(searchRequest.getPermissions());
        this.setFavourite(this.favouritesService.isFavourite(this.getLoggedInUser(), (SharedEntity)this.getSearchRequest()));
        this.searchRequestService.validateFilterForUpdate(this.getJiraServiceContext(), searchRequest);
        if (this.getReturnUrl() == null || this.getReturnUrl().length() == 0) {
            String redirectURL = "IssueNavigator.jspa?mode=hide&requestId=" + this.getSearchRequest().getId();
            this.setReturnUrl(redirectURL);
        }
        return "input";
    }

    protected void doValidation() {
        if (this.filterId == null) {
            this.addErrorMessage(this.getText("admin.errors.filters.no.search.request"));
            return;
        }
        SearchRequest oldSearchRequest = this.getSearchRequest();
        if (oldSearchRequest == null || !this.filterId.equals(oldSearchRequest.getId())) {
            oldSearchRequest = this.searchRequestService.getFilter(this.getJiraServiceContext(), this.filterId);
            if (this.hasAnyErrors()) {
                this.setSearchRequest(null);
                return;
            }
            this.setSearchRequest(oldSearchRequest);
        }
        if (oldSearchRequest != null) {
            if (!UserNames.equal(oldSearchRequest.getOwnerUserName(), this.getLoggedInUser())) {
                this.addErrorMessage(this.getText("admin.errors.filters.not.owner"));
                return;
            }
            this.setSharePermissions(oldSearchRequest.getPermissions());
        }
        if (StringUtils.isNotBlank((String)this.shareString)) {
            try {
                SharedEntity.SharePermissions permissions = SharePermissionUtils.fromJsonArrayString((String)this.shareString);
                this.setSharePermissions(permissions);
            }
            catch (JSONException e) {
                this.log.error((Object)("Unable to parse the returned SharePermissions: " + e.getMessage()), (Throwable)e);
            }
        }
        if (oldSearchRequest == null) {
            this.addErrorMessage(this.getText("admin.errors.filters.no.search.request"));
            return;
        }
        if (this.getLoggedInUser() == null) {
            this.addErrorMessage(this.getText("admin.errors.filters.no.user"));
            return;
        }
        if (!TextUtils.stringSet((String)this.getFilterName())) {
            this.addError("name", this.getText("admin.errors.filters.must.specify.name"));
        }
        SearchRequest newSearchRequest = new SearchRequest(oldSearchRequest);
        newSearchRequest.setOwnerUserName(this.getLoggedInUser() == null ? null : this.getLoggedInUser().getName());
        newSearchRequest.setName(this.getFilterName());
        newSearchRequest.setDescription(this.getFilterDescription());
        newSearchRequest.setPermissions(new SharedEntity.SharePermissions(this.getSharePermissions()));
        this.searchRequestService.validateFilterForUpdate(this.getJiraServiceContext(), newSearchRequest);
    }

    protected String doExecute() throws Exception {
        SearchRequest searchRequest = this.getSearchRequest();
        searchRequest.setName(this.getFilterName());
        searchRequest.setDescription(this.getFilterDescription());
        if (StringUtils.isNotBlank((String)this.shareString)) {
            searchRequest.setPermissions(this.getPermissions());
        }
        SearchRequest returnedRequest = this.isFavourite == null ? this.searchRequestService.updateFilter(this.getJiraServiceContext(), searchRequest) : this.searchRequestService.updateFilter(this.getJiraServiceContext(), searchRequest, this.isFavourite.booleanValue());
        this.setSearchRequest(returnedRequest);
        String redirectURL = "IssueNavigator.jspa?mode=hide&requestId=" + this.getSearchRequest().getId();
        return this.getRedirect(redirectURL);
    }

    public Set<SharePermission> getSharePermissions() {
        return this.shares;
    }

    private SharedEntity.SharePermissions getPermissions() {
        return new SharedEntity.SharePermissions(new HashSet<SharePermission>(this.shares));
    }

    private void setSharePermissions(SharedEntity.SharePermissions sharePermissions) {
        this.shares.clear();
        if (sharePermissions != null) {
            this.shares.addAll(sharePermissions.getPermissionSet());
        }
    }

    public void setShareValues(String values) {
        this.shareString = values;
    }

    public Collection<ShareTypeRendererBean> getShareTypes() {
        Collection sharesTypes = this.shareTypeFactory.getAllShareTypes();
        ArrayList<ShareTypeRendererBean> types = new ArrayList<ShareTypeRendererBean>(sharesTypes.size());
        for (ShareType shareType : sharesTypes) {
            types.add(new ShareTypeRendererBean(shareType, this.authCtx, ShareTypeRenderer.RenderMode.EDIT, SearchRequest.ENTITY_TYPE));
        }
        return types;
    }

    public String getFilterName() {
        return this.name;
    }

    public void setFilterName(String name) {
        this.name = name;
    }

    public String getFilterDescription() {
        return this.description;
    }

    public void setFilterDescription(String description) {
        this.description = description;
    }

    public void setFilterId(Long id) {
        this.filterId = id;
    }

    public Long getFilterId() {
        return this.filterId;
    }

    public String getCancelURL() {
        String cancelURL = this.getReturnUrl();
        if (cancelURL == null || cancelURL.length() == 0) {
            cancelURL = "IssueNavigator.jspa";
        }
        return cancelURL;
    }

    public boolean isFavourite() {
        return this.isFavourite;
    }

    public void setFavourite(boolean favourite) {
        this.isFavourite = favourite;
    }

    public String getJsonString() {
        ArrayList<SharePermission> sortedShares = new ArrayList<SharePermission>(this.getSharePermissions());
        Collections.sort(sortedShares, this.shareTypeFactory.getPermissionComparator());
        try {
            return SharePermissionUtils.toJsonArray(sortedShares).toString();
        }
        catch (JSONException e) {
            this.log.error((Object)("Unable to create JSON representation of shares: " + e.getMessage()), (Throwable)e);
            return "";
        }
    }

    public boolean showShares() {
        return this.isEditEnabled() || !this.getSharePermissions().isEmpty();
    }

    public boolean isEditEnabled() {
        return this.permissionsManager.hasPermission(22, this.getLoggedInUser());
    }

    public boolean isModified() {
        return this.getSearchRequest() != null && this.getSearchRequest().isModified();
    }
}

