/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.scheme.distiller;

import com.atlassian.jira.bc.scheme.distiller.SchemeDistillerService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeFactory;
import com.atlassian.jira.scheme.SchemeManagerFactory;
import com.atlassian.jira.scheme.distiller.DistilledSchemeResult;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.action.admin.scheme.distiller.AbstractMergeAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.ArrayList;
import java.util.Collection;
import webwork.action.ActionContext;

@WebSudoRequired
public class SchemeMergeResultAction
extends AbstractMergeAction {
    private ErrorCollection persistErrors;
    private Collection persistedDistilledSchemeResults;

    public SchemeMergeResultAction(SchemeManagerFactory schemeManagerFactory, SchemeFactory schemeFactory, ApplicationProperties applicationProperties, SchemeDistillerService schemeDistiller) {
        super(schemeManagerFactory, schemeFactory, applicationProperties, schemeDistiller);
    }

    protected String doExecute() throws Exception {
        this.persistErrors = new SimpleErrorCollection();
        this.persistedDistilledSchemeResults = new ArrayList();
        for (DistilledSchemeResult distilledSchemeResult : this.getDistilledSchemeResults().getDistilledSchemeResults()) {
            Scheme persistedScheme;
            if (!distilledSchemeResult.isSelected() || (persistedScheme = this.schemeDistiller.persistNewSchemeMappings(this.getLoggedInUser(), distilledSchemeResult, this.persistErrors)) == null) continue;
            this.persistedDistilledSchemeResults.add(distilledSchemeResult);
        }
        ActionContext.getSession().remove("__distilledSchemesKey");
        return "success";
    }

    public Collection getPersistedDistilledSchemeResults() {
        return this.persistedDistilledSchemeResults;
    }

    public ErrorCollection getPersistErrors() {
        return this.persistErrors;
    }
}

