/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.roles;

import com.atlassian.jira.bc.projectroles.ProjectRoleService;
import com.atlassian.jira.bc.user.search.UserPickerSearchService;
import com.atlassian.jira.issue.comparator.UserBestNameComparator;
import com.atlassian.jira.project.ProjectFactory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.roles.ProjectRoleActor;
import com.atlassian.jira.security.roles.RoleActorFactory;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.action.admin.roles.AbstractRoleActorAction;
import com.atlassian.jira.web.component.multiuserpicker.UserPickerLayoutBean;
import com.atlassian.jira.web.component.multiuserpicker.UserPickerWebComponent;
import java.util.Collection;
import java.util.TreeSet;
import webwork.action.ActionContext;

public class UserRoleActorAction
extends AbstractRoleActorAction {
    private static final String REMOVE_USERS_PREFIX = "removeusers_";
    private String userNames;
    private final ProjectRoleService projectRoleService;
    private final VelocityTemplatingEngine templatingEngine;
    private final UserPickerSearchService searchService;

    public UserRoleActorAction(ProjectRoleService projectRoleService, ProjectManager projectManager, ProjectFactory projectFactory, RoleActorFactory roleActorFactory, VelocityTemplatingEngine templatingEngine, UserPickerSearchService searchService) {
        super(projectRoleService, projectManager, projectFactory, roleActorFactory);
        this.projectRoleService = projectRoleService;
        this.templatingEngine = templatingEngine;
        this.searchService = searchService;
    }

    public String doExecute() {
        if (!this.projectRoleService.hasProjectRolePermission(this.getLoggedInUser(), this.getProject())) {
            return "securitybreach";
        }
        return "success";
    }

    public String getUserPickerHtml() {
        String removeUsersAction = "UserRoleActorAction!removeUsers.jspa?projectRoleId=" + this.getProjectRoleId() + (this.getProject() != null ? "&projectId=" + this.getProjectId() : "");
        String addUserAction = "UserRoleActorAction!addUsers.jspa?projectRoleId=" + this.getProjectRoleId() + (this.getProject() != null ? "&projectId=" + this.getProjectId() : "");
        UserPickerLayoutBean userPickerLayoutBean = new UserPickerLayoutBean("admin.user.role.actor.action", REMOVE_USERS_PREFIX, removeUsersAction, addUserAction);
        UserPickerWebComponent userPickerWebComponent = new UserPickerWebComponent(this.templatingEngine, this.getApplicationProperties(), this.searchService);
        return userPickerWebComponent.getHtml(userPickerLayoutBean, this.getProjectRoleActorUsers(), true, this.getProjectRoleId());
    }

    private Collection getProjectRoleActorUsers() {
        Object defaultRoleActors = this.getProject() == null ? this.projectRoleService.getDefaultRoleActors(this.getLoggedInUser(), this.getProjectRole(), (ErrorCollection)this) : this.projectRoleService.getProjectRoleActors(this.getLoggedInUser(), this.getProjectRole(), this.getProject(), (ErrorCollection)this);
        TreeSet usersByType = new TreeSet(new UserBestNameComparator(this.getLocale()));
        if (defaultRoleActors != null) {
            for (ProjectRoleActor projectRoleActor : defaultRoleActors.getRoleActorsByType("atlassian-user-role-actor")) {
                usersByType.addAll(projectRoleActor.getUsers());
            }
        }
        return usersByType;
    }

    @RequiresXsrfCheck
    public String doRemoveUsers() {
        Collection userNamesToRemove = UserPickerWebComponent.getUserNamesToRemove(ActionContext.getParameters(), REMOVE_USERS_PREFIX);
        if (this.getProject() == null) {
            this.projectRoleService.removeDefaultActorsFromProjectRole(this.getLoggedInUser(), userNamesToRemove, this.getProjectRole(), "atlassian-user-role-actor", (ErrorCollection)this);
        } else {
            this.projectRoleService.removeActorsFromProjectRole(this.getLoggedInUser(), userNamesToRemove, this.getProjectRole(), this.getProject(), "atlassian-user-role-actor", (ErrorCollection)this);
        }
        if (this.hasAnyErrors()) {
            return "error";
        }
        return "success";
    }

    @RequiresXsrfCheck
    public String doAddUsers() {
        Collection userNamesToAdd = UserPickerWebComponent.getUserNamesToAdd(this.getUserNames());
        if (this.getProject() == null) {
            this.projectRoleService.addDefaultActorsToProjectRole(this.getLoggedInUser(), userNamesToAdd, this.getProjectRole(), "atlassian-user-role-actor", (ErrorCollection)this);
        } else {
            this.projectRoleService.addActorsToProjectRole(this.getLoggedInUser(), userNamesToAdd, this.getProjectRole(), this.getProject(), "atlassian-user-role-actor", (ErrorCollection)this);
        }
        if (this.hasAnyErrors()) {
            return "error";
        }
        return "success";
    }

    public String getUserNames() {
        return this.userNames;
    }

    public void setUserNames(String userNames) {
        this.userNames = userNames;
    }
}

