/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.priorities;

import com.atlassian.jira.config.PriorityManager;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.constants.AbstractDeleteConstant;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;
import org.ofbiz.core.entity.GenericValue;

@WebSudoRequired
public class DeletePriority
extends AbstractDeleteConstant {
    private final PriorityManager priorityManager;

    public DeletePriority(PriorityManager priorityManager) {
        this.priorityManager = priorityManager;
    }

    @Override
    protected String getConstantEntityName() {
        return "Priority";
    }

    @Override
    protected String getNiceConstantName() {
        return this.getText("admin.issue.constant.priority.lowercase");
    }

    @Override
    protected String getIssueConstantField() {
        return "priority";
    }

    @Override
    protected GenericValue getConstant(String id) {
        Priority priorityObject = this.getConstantsManager().getPriorityObject(id);
        return priorityObject != null ? priorityObject.getGenericValue() : null;
    }

    @Override
    protected String getRedirectPage() {
        return "ViewPriorities.jspa";
    }

    @Override
    protected Collection<GenericValue> getConstants() {
        return this.getConstantsManager().getPriorities();
    }

    @Override
    protected void clearCaches() {
        this.getConstantsManager().refreshPriorities();
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (this.confirm) {
            this.priorityManager.removePriority(this.id, this.newId);
        }
        if (this.getHasErrorMessages()) {
            return "error";
        }
        return this.getRedirect(this.getRedirectPage());
    }
}

