/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.permission;

import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.permission.PermissionTypeManager;
import com.atlassian.jira.permission.SchemePermissions;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.permission.SchemeAwarePermissionAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@WebSudoRequired
public class DeletePermission
extends SchemeAwarePermissionAction {
    private Long id;
    private boolean confirmed = false;
    private final SchemePermissions schemePermissions;
    private final PermissionTypeManager permTypeManager;

    public DeletePermission(SchemePermissions schemePermissions, PermissionTypeManager permTypeManager) {
        this.schemePermissions = schemePermissions;
        this.permTypeManager = permTypeManager;
    }

    protected void doValidation() {
        if (this.id == null) {
            this.addErrorMessage(this.getText("admin.errors.permissions.specify.permission.to.delete"));
        }
        if (!this.confirmed) {
            this.addErrorMessage(this.getText("admin.errors.permissions.confirm.deletion"));
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        ManagerFactory.getPermissionSchemeManager().deleteEntity(this.getId());
        return this.getRedirect(this.getRedirectURL());
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    private GenericValue getPermission() throws GenericEntityException {
        return ManagerFactory.getPermissionSchemeManager().getEntity(this.id);
    }

    public String getPermissionDisplayName() throws GenericEntityException {
        return this.getType(this.getPermission().getString("type")).getDisplayName();
    }

    public String getPermissionParameter() throws GenericEntityException {
        GenericValue permissionGV = this.getPermission();
        String param = permissionGV.getString("parameter");
        String type = permissionGV.getString("type");
        return this.permTypeManager.getSecurityType(type).getArgumentDisplay(param);
    }

    public String getPermissionName() throws GenericEntityException {
        return this.schemePermissions.getPermissionName(Integer.valueOf(this.getPermission().getString("permission")));
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    @Override
    public SchemeManager getSchemeManager() {
        return ManagerFactory.getPermissionSchemeManager();
    }

    @Override
    public String getRedirectURL() {
        if (this.getSchemeId() == null) {
            return "ViewPermissionSchemes.jspa";
        }
        return "EditPermissions!default.jspa?schemeId=" + this.getSchemeId();
    }
}

