/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.linking;

import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import java.util.Collection;

@WebSudoRequired
public class ViewLinkTypes
extends JiraWebActionSupport {
    private String name;
    private String outward;
    private String inward;
    private final IssueLinkTypeManager issueLinkTypeManager;

    public ViewLinkTypes(IssueLinkTypeManager issueLinkTypeManager) {
        this.issueLinkTypeManager = issueLinkTypeManager;
    }

    protected void doValidation() {
        if (this.name != null || this.outward != null || this.inward != null) {
            Collection existing;
            if (!TextUtils.stringSet((String)this.name)) {
                this.addError("name", this.getText("admin.errors.you.must.specify.a.name.for.this.link.type"));
            }
            if (!TextUtils.stringSet((String)this.outward)) {
                this.addError("outward", this.getText("admin.errors.please.specify.a.description.for.the.outward.link"));
            }
            if (!TextUtils.stringSet((String)this.inward)) {
                this.addError("inward", this.getText("admin.errors.please.specify.a.description.for.the.inward.link"));
            }
            if ((existing = this.issueLinkTypeManager.getIssueLinkTypesByName(this.name)) != null && existing.size() > 0) {
                this.addError("name", this.getText("admin.errors.another.link.type.with.that.name.already.exists"));
            }
        }
    }

    public String doDefault() throws Exception {
        return "success";
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (this.name != null) {
            this.issueLinkTypeManager.createIssueLinkType(this.getName(), this.getOutward(), this.getInward(), null);
            this.refreshState();
        }
        return this.getResult();
    }

    @RequiresXsrfCheck
    public String doActivate() throws Exception {
        this.getApplicationProperties().setOption("jira.option.issuelinking", true);
        return this.getResult();
    }

    @RequiresXsrfCheck
    public String doDeactivate() throws Exception {
        this.getApplicationProperties().setOption("jira.option.issuelinking", false);
        return this.getResult();
    }

    public Collection getLinkTypes() {
        return this.issueLinkTypeManager.getIssueLinkTypes();
    }

    public boolean getIssueLinking() {
        return this.getApplicationProperties().getOption("jira.option.issuelinking");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOutward() {
        return this.outward;
    }

    public void setOutward(String outward) {
        this.outward = outward;
    }

    public String getInward() {
        return this.inward;
    }

    public void setInward(String inward) {
        this.inward = inward;
    }

    private void refreshState() {
        this.name = null;
        this.inward = null;
        this.outward = null;
    }
}

