/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;

public class GlobalPermissionGroupAssociationUtil {
    public static final Transformer GROUP_TO_GROUPNAME = new Transformer(){

        public Object transform(Object object) {
            return ((Group)object).getName();
        }
    };
    private final GlobalPermissionManager globalPermissionManager;
    private final GroupManager groupManager;

    public GlobalPermissionGroupAssociationUtil(GlobalPermissionManager globalPermissionManager, GroupManager groupManager) {
        this.globalPermissionManager = globalPermissionManager;
        this.groupManager = groupManager;
    }

    public boolean isRemovingAllMySysAdminGroups(Collection groupsToLeave, User user) {
        Collection<String> sysAdminGroups = this.getSysAdminMemberGroups(user);
        sysAdminGroups.removeAll(groupsToLeave);
        return sysAdminGroups.isEmpty();
    }

    public Collection<String> getSysAdminMemberGroups(User user) {
        return this.getMemberGroupNames(user, 44);
    }

    public boolean isRemovingAllMyAdminGroups(Collection groupsToLeave, User user) {
        Collection<String> startingAdminGroups = this.getAdminMemberGroups(user);
        startingAdminGroups.removeAll(groupsToLeave);
        return startingAdminGroups.isEmpty();
    }

    public Collection<String> getAdminMemberGroups(User user) {
        return this.getMemberGroupNames(user, 0);
    }

    public boolean isUserAbleToDeleteGroup(User user, String groupName) {
        return this.globalPermissionManager.hasPermission(44, user) || !this.globalPermissionManager.getGroupNames(44).contains(groupName);
    }

    public List<String> getGroupNamesModifiableByCurrentUser(User currentUser, Collection<String> groupNames) {
        Collection sysAdminGroupNames;
        ArrayList<String> visibleGroups;
        ArrayList<String> arrayList = visibleGroups = groupNames != null ? new ArrayList<String>(groupNames) : new ArrayList();
        if (!this.globalPermissionManager.hasPermission(44, currentUser) && (sysAdminGroupNames = this.globalPermissionManager.getGroupNames(44)) != null) {
            visibleGroups.removeAll(sysAdminGroupNames);
        }
        Collections.sort(visibleGroups);
        return visibleGroups;
    }

    public List<Group> getGroupsModifiableByCurrentUser(User currentUser, List<Group> groups) {
        Collection sysAdminGroups;
        ArrayList<Group> visibleGroups;
        ArrayList<Object> arrayList = visibleGroups = groups != null ? new ArrayList<Group>(groups) : new ArrayList();
        if (!this.globalPermissionManager.hasPermission(44, currentUser) && (sysAdminGroups = this.globalPermissionManager.getGroupsWithPermission(44)) != null) {
            visibleGroups.removeAll(sysAdminGroups);
        }
        Collections.sort(visibleGroups);
        return visibleGroups;
    }

    public List<Group> getNonAdminGroups(List<Group> groups) {
        ArrayList<Group> visibleGroups = groups != null ? new ArrayList<Group>(groups) : new ArrayList();
        Collection sysAdminGroups = this.globalPermissionManager.getGroupsWithPermission(44);
        if (sysAdminGroups != null) {
            visibleGroups.removeAll(sysAdminGroups);
        }
        Collection adminGroups = this.globalPermissionManager.getGroupsWithPermission(0);
        if (sysAdminGroups != null) {
            visibleGroups.removeAll(adminGroups);
        }
        Collections.sort(visibleGroups);
        return visibleGroups;
    }

    Collection<String> getMemberGroupNames(User user, int permissionType) {
        Collection permissionTypeGroups = this.globalPermissionManager.getGroupNames(permissionType);
        Collection userGroups = this.groupManager.getGroupNamesForUser(user);
        if (userGroups == null) {
            return Collections.emptyList();
        }
        return CollectionUtils.intersection((Collection)userGroups, (Collection)permissionTypeGroups);
    }
}

