/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryStore;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@ThreadSafe
public class OfBizUserHistoryStore
implements UserHistoryStore {
    private static final Logger log = Logger.getLogger(OfBizUserHistoryStore.class);
    private static final String TABLE = "UserHistoryItem";
    private static final int DEFAULT_MAX_ITEMS = 50;
    private final OfBizDelegator delegator;
    private final ApplicationProperties applicationProperties;

    public OfBizUserHistoryStore(OfBizDelegator delegator, ApplicationProperties applicationProperties) {
        this.delegator = delegator;
        this.applicationProperties = applicationProperties;
    }

    @Override
    public void addHistoryItem(@NotNull ApplicationUser user, @NotNull UserHistoryItem item) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"historyItem", (Object)item);
        int numberRemoved = this.delegator.removeByAnd(TABLE, EasyMap.build((Object)"type", (Object)item.getType().getName(), (Object)"username", (Object)user.getKey(), (Object)"entityId", (Object)item.getEntityId()));
        this.delegator.createValue(TABLE, EasyMap.build((Object)"type", (Object)item.getType().getName(), (Object)"username", (Object)user.getKey(), (Object)"entityId", (Object)item.getEntityId(), (Object)"lastViewed", (Object)item.getLastViewed(), (Object)"data", (Object)item.getData()));
        if (numberRemoved == 0) {
            String maxItemsStr = this.applicationProperties.getDefaultBackedString("jira.max.history.items");
            int maxItems = 50;
            try {
                maxItems = Integer.parseInt(maxItemsStr);
            }
            catch (NumberFormatException e) {
                log.warn((Object)"Incorrect format of property 'jira.max.history.items'.  Should be a number.");
            }
            List historyItemGVs = this.delegator.findByAnd(TABLE, EasyMap.build((Object)"type", (Object)item.getType().getName(), (Object)"username", (Object)user.getKey()), EasyList.build((Object)"lastViewed DESC"));
            for (int i = maxItems; i < historyItemGVs.size(); ++i) {
                this.delegator.removeByAnd(TABLE, EasyMap.build((Object)"id", (Object)((GenericValue)historyItemGVs.get(i)).getLong("id")));
            }
        }
    }

    public void addHistoryItemNoChecks(@NotNull ApplicationUser user, @NotNull UserHistoryItem item) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"historyItem", (Object)item);
        this.delegator.createValue(TABLE, EasyMap.build((Object)"type", (Object)item.getType().getName(), (Object)"username", (Object)user.getKey(), (Object)"entityId", (Object)item.getEntityId(), (Object)"lastViewed", (Object)item.getLastViewed(), (Object)"data", (Object)item.getData()));
    }

    public void updateHistoryItemNoChecks(@NotNull ApplicationUser user, @NotNull UserHistoryItem item) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"historyItem", (Object)item);
        List list = this.delegator.findByAnd(TABLE, EasyMap.build((Object)"type", (Object)item.getType().getName(), (Object)"username", (Object)user.getKey(), (Object)"entityId", (Object)item.getEntityId()));
        if (list == null || list.size() == 0) {
            this.delegator.createValue(TABLE, EasyMap.build((Object)"type", (Object)item.getType().getName(), (Object)"username", (Object)user.getKey(), (Object)"entityId", (Object)item.getEntityId(), (Object)"lastViewed", (Object)item.getLastViewed(), (Object)"data", (Object)item.getData()));
        } else if (list.size() == 1) {
            GenericValue genericValue = (GenericValue)list.get(0);
            genericValue.set("lastViewed", (Object)item.getLastViewed());
            try {
                genericValue.store();
            }
            catch (GenericEntityException e) {
                log.error((Object)"Exception thrown while updating user history item", (Throwable)e);
            }
        } else {
            log.warn((Object)("Somehow there is more than one record for the following user/type/entity - " + item.toString()));
        }
    }

    public void expireOldHistoryItems(@NotNull ApplicationUser user, @NotNull UserHistoryItem.Type type, Collection<String> entityIds) {
        for (String entityId : entityIds) {
            this.delegator.removeByAnd(TABLE, EasyMap.build((Object)"username", (Object)user.getKey(), (Object)"type", (Object)type.getName(), (Object)"entityId", (Object)entityId));
        }
    }

    @Override
    @NotNull
    public List<UserHistoryItem> getHistory(@NotNull UserHistoryItem.Type type, @NotNull ApplicationUser user) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"type", (Object)type);
        List historyItemGVs = this.delegator.findByAnd(TABLE, EasyMap.build((Object)"type", (Object)type.getName(), (Object)"username", (Object)user.getKey()), EasyList.build((Object)"lastViewed DESC"));
        ArrayList<UserHistoryItem> returnList = new ArrayList<UserHistoryItem>();
        for (GenericValue historyItemGV : historyItemGVs) {
            returnList.add(this.convertGV(historyItemGV));
        }
        return returnList;
    }

    @Override
    public Set<UserHistoryItem.Type> removeHistoryForUser(@NotNull ApplicationUser user) {
        Assertions.notNull((String)"user", (Object)user);
        List historyItemGVs = this.delegator.findByAnd(TABLE, EasyMap.build((Object)"username", (Object)user.getKey()));
        HashSet<UserHistoryItem.Type> types = new HashSet<UserHistoryItem.Type>();
        if (historyItemGVs != null && !historyItemGVs.isEmpty()) {
            for (GenericValue historyItemGV : historyItemGVs) {
                types.add(UserHistoryItem.Type.getInstance((String)historyItemGV.getString("type")));
            }
            this.delegator.removeByAnd(TABLE, EasyMap.build((Object)"username", (Object)user.getKey()));
        }
        return types;
    }

    private UserHistoryItem convertGV(GenericValue historyItemGV) {
        return new UserHistoryItem(UserHistoryItem.Type.getInstance((String)historyItemGV.getString("type")), historyItemGV.getString("entityId"), historyItemGV.getLong("lastViewed").longValue(), historyItemGV.getString("data"));
    }

    private static final class Columns {
        public static final String ID = "id";
        public static final String USER = "username";
        public static final String TYPE = "type";
        public static final String ENTITY_ID = "entityId";
        public static final String LAST_VIEWED = "lastViewed";
        public static final String DATA = "data";

        private Columns() {
        }
    }
}

