/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.cache.GoogleCacheInstruments;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.ofbiz.DefaultOfBizConnectionFactory;
import com.atlassian.jira.ofbiz.OfBizConnectionFactory;
import com.atlassian.jira.user.CachingExternalEntityStore;
import com.atlassian.jira.user.ExternalEntityStore;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Function;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

@EventComponent
public class DefaultUserPropertyManager
implements UserPropertyManager,
Startable {
    protected final Cache<String, PropertySet> psCache = CacheBuilder.newBuilder().maximumSize(500).expireAfterAccess(30L, TimeUnit.MINUTES).build(CacheLoader.from((Function)new CreatePropertySetFunction()));
    private static final String ENTITY_TYPE = "ExternalEntity";
    private final ExternalEntityStore externalEntityStore;
    private final OfBizConnectionFactory ofBizConnectionFactory = new DefaultOfBizConnectionFactory();

    public DefaultUserPropertyManager(ExternalEntityStore externalEntityStore) {
        this.externalEntityStore = externalEntityStore;
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        ((CachingExternalEntityStore)ComponentManager.getComponentInstanceOfType(ExternalEntityStore.class)).onClearCache(null);
        this.psCache.invalidateAll();
    }

    public void start() throws Exception {
        new GoogleCacheInstruments(this.getClass().getSimpleName()).addCache(this.psCache).install();
    }

    public PropertySet getPropertySet(User user) {
        Assertions.notNull((String)"user", (Object)user);
        String lowercaseName = IdentifierUtils.toLowerCase((String)user.getName());
        try {
            return (PropertySet)this.psCache.get((Object)lowercaseName);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Error creating property set for user: " + lowercaseName, e);
        }
    }

    public void clearCache(String username) {
        this.psCache.invalidate((Object)IdentifierUtils.toLowerCase((String)username));
    }

    private class CreatePropertySetFunction
    implements Function<String, PropertySet> {
        private CreatePropertySetFunction() {
        }

        public PropertySet apply(String name) {
            Long id = DefaultUserPropertyManager.this.externalEntityStore.createIfDoesNotExist(name);
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("entityId", id);
            args.put("entityName", DefaultUserPropertyManager.ENTITY_TYPE);
            args.put("delegator.name", DefaultUserPropertyManager.this.ofBizConnectionFactory.getDelegatorName());
            PropertySet basePs = PropertySetManager.getInstance((String)"ofbiz", args);
            args.clear();
            args.put("PropertySet", basePs);
            PropertySet ps = PropertySetManager.getInstance((String)"cached", args);
            return ps;
        }
    }
}

