/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.util;

import com.atlassian.jira.upgrade.util.LegacyPortletUpgradeTask;
import com.opensymphony.module.propertyset.PropertySet;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractLegacyPortletUpgradeTask
implements LegacyPortletUpgradeTask {
    protected static final String MULTIVALUE_SEPARATOR = "|";
    protected static final String SEPARATOR_ENCODED = "%7C";
    public static final String PORTLET_MULTI_VALUE_SEPARATOR = "_*|*_";

    @Override
    public abstract String getPortletKey();

    @Override
    public abstract URI getGadgetUri();

    @Override
    public Map<String, String> convertUserPrefs(PropertySet propertySet) {
        Collection keys = propertySet.getKeys();
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        for (String key : keys) {
            String value;
            int type = propertySet.getType(key);
            if (type == 5) {
                value = propertySet.getString(key);
            } else {
                Object o = propertySet.getAsActualType(key);
                String string = value = o == null ? null : o.toString();
            }
            if (value != null && value.contains(PORTLET_MULTI_VALUE_SEPARATOR)) {
                value = this.convertMultiSelectValue(value);
            }
            ret.put(key, value);
        }
        return ret;
    }

    protected String convertMultiSelectValue(String values) {
        List<String> valuesList = this.getListFromMultiSelectValue(values);
        StringBuilder ret = new StringBuilder();
        Iterator<String> valueIterator = valuesList.iterator();
        while (valueIterator.hasNext()) {
            String value = valueIterator.next();
            ret.append(value.replace(MULTIVALUE_SEPARATOR, SEPARATOR_ENCODED));
            if (!valueIterator.hasNext()) continue;
            ret.append(MULTIVALUE_SEPARATOR);
        }
        return ret.toString();
    }

    private List<String> getListFromMultiSelectValue(String values) {
        String[] vals = StringUtils.splitByWholeSeparator((String)values, (String)PORTLET_MULTI_VALUE_SEPARATOR);
        return vals == null ? Collections.emptyList() : Arrays.asList(vals);
    }
}

