/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.EntityListConsumer;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.entity.Update;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import java.util.ArrayList;
import java.util.List;

public class UpgradeTask_Build771
extends AbstractUpgradeTask {
    private final EntityEngine entityEngine;
    private final UserManager userManager;

    public UpgradeTask_Build771(EntityEngine entityEngine, UserManager userManager) {
        super(false);
        this.entityEngine = entityEngine;
        this.userManager = userManager;
    }

    @Override
    public String getBuildNumber() {
        return "771";
    }

    @Override
    public String getShortDescription() {
        return "Convert username to lowercase in UserHistoryItem and FilterSubscription";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        this.updateUserHistoryItem();
        this.updateFilterSubscription();
    }

    private void updateFilterSubscription() {
        Select.SelectColumnsFromContext<String> selectQuery = Select.distinctString("username").from("FilterSubscription");
        List<String> usernamesToConvert = this.entityEngine.run(selectQuery).consumeWith(new FindMixedCaseUsernames());
        for (String username : usernamesToConvert) {
            this.entityEngine.execute(Update.into("FilterSubscription").set("username", IdentifierUtils.toLowerCase((String)username)).whereEqual("username", username));
        }
    }

    private void updateUserHistoryItem() {
        Select.SelectColumnsFromContext<String> selectQuery = Select.distinctString("username").from("UserHistoryItem");
        List<String> usernamesToConvert = this.entityEngine.run(selectQuery).consumeWith(new FindMixedCaseUsernames());
        for (String username : usernamesToConvert) {
            ApplicationUser user = this.userManager.getUserByName(username);
            if (user != null && user.getName().equals(username)) {
                this.entityEngine.delete(Delete.from("UserHistoryItem").whereEqual("username", IdentifierUtils.toLowerCase((String)username)));
                this.entityEngine.execute(Update.into("UserHistoryItem").set("username", IdentifierUtils.toLowerCase((String)username)).whereEqual("username", username));
                continue;
            }
            this.entityEngine.delete(Delete.from("UserHistoryItem").whereEqual("username", username));
        }
    }

    private static final class FindMixedCaseUsernames
    implements EntityListConsumer<String, List<String>> {
        private final List<String> usernames = new ArrayList<String>();

        private FindMixedCaseUsernames() {
        }

        @Override
        public void consume(String username) {
            if (username != null && !username.equals(IdentifierUtils.toLowerCase((String)username))) {
                this.usernames.add(username);
            }
        }

        @Override
        public List<String> result() {
            return this.usernames;
        }
    }
}

