/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build641
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask_Build641.class);
    private final PermissionSchemeManager permissionSchemeManager;
    private final ProjectRoleManager projectRoleManager;
    private final PermissionManager permissionManager;

    public UpgradeTask_Build641(PermissionManager permissionManager, PermissionSchemeManager permissionSchemeManager, ProjectRoleManager projectRoleManager) {
        super(false);
        this.permissionManager = permissionManager;
        this.permissionSchemeManager = permissionSchemeManager;
        this.projectRoleManager = projectRoleManager;
    }

    @Override
    public String getBuildNumber() {
        return "641";
    }

    @Override
    public String getShortDescription() {
        return "Gives View Only Workflow permission to Users on SETUP ONLY.";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        log.info((Object)"Adding 'View Only Workflow' permissions to the Users project role...");
        GenericValue defaultScheme = this.permissionSchemeManager.getDefaultScheme();
        ProjectRole projectRole = this.projectRoleManager.getProjectRole("Users");
        if (projectRole != null) {
            this.permissionManager.addPermission(45, defaultScheme, projectRole.getId().toString(), "projectrole");
        }
        log.info((Object)"Done adding 'View Only Workflow' permissions to the Users project role.");
    }
}

