/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.startup.JiraHomePathLocator;
import org.apache.log4j.Logger;

public class SystemPropertyJiraHomePathLocator
implements JiraHomePathLocator {
    private static final Logger log = Logger.getLogger(SystemPropertyJiraHomePathLocator.class);

    @Override
    public String getJiraHome() {
        try {
            return System.getProperty("jira.home");
        }
        catch (SecurityException e) {
            String message = String.format("Unable to obtain JIRA home from system property: %s.", e.getMessage());
            if (log.isDebugEnabled()) {
                log.debug((Object)message, (Throwable)e);
            } else {
                log.info((Object)message);
            }
            return null;
        }
    }

    @Override
    public String getDisplayName() {
        return "System Property";
    }
}

