/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.soap.axis;

import com.atlassian.jira.plugin.rpc.SoapModuleDescriptor;
import com.atlassian.jira.soap.axis.JiraAxisJavaPicoRPCProvider;
import com.atlassian.jira.soap.axis.JiraAxisSoapLog;
import org.apache.axis.AxisFault;
import org.apache.axis.Handler;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.soap.SOAPService;

public class JiraAxisSoapService
extends SOAPService {
    private JiraAxisSoapLog jiraSoapLogger;

    public JiraAxisSoapService(SoapModuleDescriptor descriptor) {
        this(descriptor, new JiraAxisJavaPicoRPCProvider(descriptor));
    }

    private JiraAxisSoapService(SoapModuleDescriptor descriptor, JiraAxisJavaPicoRPCProvider picoRpcProvider) {
        super((Handler)picoRpcProvider);
        this.setName(descriptor.getServicePath());
        this.setServiceInterfaceName(descriptor.getPublishedInterface().getName());
        this.setOption("allowedMethods", "*");
        this.setOption("scope", "Application");
        this.jiraSoapLogger = new JiraAxisSoapLog(picoRpcProvider);
    }

    private void setServiceInterfaceName(String interfaceName) {
        this.setOption("className", interfaceName);
    }

    public void invoke(MessageContext msgContext) throws AxisFault {
        int httpResponseCode = 200;
        long then = System.currentTimeMillis();
        try {
            super.invoke(msgContext);
        }
        catch (AxisFault axisFault) {
            httpResponseCode = 500;
            throw axisFault;
        }
        finally {
            long reponseTime = System.currentTimeMillis() - then;
            this.jiraSoapLogger.logMessage(msgContext, httpResponseCode, reponseTime);
        }
    }
}

