/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.SharedEntityAccessor;
import com.atlassian.util.concurrent.LazyReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class DefaultSharedEntityAccessorFactory
implements SharedEntityAccessor.Factory {
    private final LazyReference<Map<SharedEntity.TypeDescriptor<?>, SharedEntityAccessor<?>>> adjusters = new LazyReference<Map<SharedEntity.TypeDescriptor<?>, SharedEntityAccessor<?>>>(){

        protected Map<SharedEntity.TypeDescriptor<?>, SharedEntityAccessor<?>> create() throws Exception {
            HashMap<SharedEntity.TypeDescriptor, SharedEntityAccessor> localAdjusters = new HashMap<SharedEntity.TypeDescriptor, SharedEntityAccessor>();
            for (SharedEntityAccessor sharedEntityAccessor : DefaultSharedEntityAccessorFactory.this.getAccessors()) {
                localAdjusters.put(sharedEntityAccessor.getType(), sharedEntityAccessor);
            }
            return Collections.unmodifiableMap(localAdjusters);
        }
    };

    public <S extends SharedEntity> SharedEntityAccessor<S> getSharedEntityAccessor(SharedEntity.TypeDescriptor<S> type) {
        if (type == null) {
            return null;
        }
        SharedEntityAccessor sharedEntityAccessor = (SharedEntityAccessor)((Map)this.adjusters.get()).get(type);
        return sharedEntityAccessor;
    }

    public <S extends SharedEntity> SharedEntityAccessor<S> getSharedEntityAccessor(String type) {
        if (StringUtils.isBlank((String)type)) {
            return null;
        }
        return this.getSharedEntityAccessor(new SharedEntity.TypeDescriptor(type));
    }

    List<SharedEntityAccessor> getAccessors() {
        return ComponentManager.getComponentsOfType(SharedEntityAccessor.class);
    }
}

