/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.auth.trustedapps;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.util.dbc.Null;
import org.apache.commons.lang.StringUtils;

public interface UserNameTransformer {
    public String transform(String var1);

    public static class Factory {
        private final ClassNameRetriever retriever;

        public Factory(ClassNameRetriever retriever) {
            Null.not("retriever", retriever);
            this.retriever = retriever;
        }

        UserNameTransformer get() {
            Class<UserNameTransformer> retrieverClass = this.retriever.get();
            if (retrieverClass == null) {
                retrieverClass = LowerCase.class;
            }
            try {
                return retrieverClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class ApplicationPropertiesClassNameRetriever
    implements ClassNameRetriever {
        private final ApplicationProperties properties;

        public ApplicationPropertiesClassNameRetriever(ApplicationProperties properties) {
            this.properties = properties;
        }

        @Override
        public Class<UserNameTransformer> get() {
            String className = this.properties.getDefaultBackedString("jira.trustedapps.user.name.transformation.policy.class");
            if (StringUtils.isBlank((String)className)) {
                return null;
            }
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static interface ClassNameRetriever {
        public Class<UserNameTransformer> get();
    }

    public static class NoOp
    implements UserNameTransformer {
        @Override
        public String transform(String userName) {
            return userName;
        }
    }

    public static class LowerCase
    implements UserNameTransformer {
        @Override
        public String transform(String userName) {
            return userName == null ? null : userName.toLowerCase();
        }
    }
}

