/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.auth.trustedapps;

import com.atlassian.jira.security.auth.trustedapps.KeyFactory;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationUtil;
import com.atlassian.jira.util.dbc.Null;
import com.atlassian.security.auth.trustedapps.DefaultTrustedApplication;
import com.atlassian.security.auth.trustedapps.RequestConditions;
import com.atlassian.security.auth.trustedapps.TrustedApplication;
import java.security.PublicKey;

public class TrustedApplicationInfo
extends DefaultTrustedApplication
implements TrustedApplication {
    private final long id;
    private final String name;
    private final long timeout;
    private final String ipMatch;
    private final String urlMatch;

    TrustedApplicationInfo(long id, String applicationId, String name, long timeout, String ipMatch, String urlMatch, PublicKey publicKey) {
        super(publicKey, applicationId, name, TrustedApplicationInfo.buildRequestConditions(timeout, ipMatch, urlMatch));
        Null.not("applicationId", applicationId);
        this.id = id;
        this.name = name;
        this.timeout = timeout;
        this.ipMatch = ipMatch;
        this.urlMatch = urlMatch;
    }

    public long getNumericId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getIpMatch() {
        return this.ipMatch;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public String getUrlMatch() {
        return this.urlMatch;
    }

    public boolean isValidKey() {
        return !(this.getPublicKey() instanceof KeyFactory.InvalidPublicKey);
    }

    private static RequestConditions buildRequestConditions(long timeout, String ipMatches, String urlMatches) {
        RequestConditions.RulesBuilder result = RequestConditions.builder().setCertificateTimeout(timeout);
        if (ipMatches != null) {
            for (String ipMatch : TrustedApplicationUtil.getLines(ipMatches)) {
                result.addIPPattern(new String[]{ipMatch});
            }
        }
        if (urlMatches != null) {
            for (String urlMatch : TrustedApplicationUtil.getLines(urlMatches)) {
                result.addURLPattern(new String[]{urlMatch});
            }
        }
        return result.build();
    }
}

