/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.propertyset;

import com.atlassian.jira.propertyset.PropertySetCache;
import com.opensymphony.module.propertyset.PropertyException;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetSchema;
import com.opensymphony.util.DataUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.w3c.dom.Document;

public class JiraCachingPropertySet
implements PropertySet,
Serializable {
    private final Lock lock;
    private PropertySet decoratedPS;
    private PropertySetCache propertySetCache;

    public JiraCachingPropertySet() {
        this(new ReentrantLock());
    }

    JiraCachingPropertySet(Lock lock) {
        this.lock = lock;
    }

    public void setAsActualType(String key, Object value) throws PropertyException {
        if (value instanceof Boolean) {
            this.setBoolean(key, DataUtil.getBoolean((Boolean)((Boolean)value)));
        } else if (value instanceof Integer) {
            this.setInt(key, DataUtil.getInt((Integer)((Integer)value)));
        } else if (value instanceof Long) {
            this.setLong(key, DataUtil.getLong((Long)((Long)value)));
        } else if (value instanceof Double) {
            this.setDouble(key, DataUtil.getDouble((Double)((Double)value)));
        } else if (value instanceof String) {
            this.setString(key, (String)value);
        } else if (value instanceof Date) {
            this.setDate(key, (Date)value);
        } else if (value instanceof Document) {
            this.setXML(key, (Document)value);
        } else if (value instanceof byte[]) {
            this.setData(key, (byte[])value);
        } else if (value instanceof Properties) {
            this.setProperties(key, (Properties)value);
        } else {
            this.setObject(key, value);
        }
    }

    public Object getAsActualType(String key) throws PropertyException {
        int type = this.getType(key);
        Object value = null;
        switch (type) {
            case 1: {
                value = this.getBoolean(key);
                break;
            }
            case 2: {
                value = this.getInt(key);
                break;
            }
            case 3: {
                value = this.getLong(key);
                break;
            }
            case 4: {
                value = this.getDouble(key);
                break;
            }
            case 5: {
                value = this.getString(key);
                break;
            }
            case 7: {
                value = this.getDate(key);
                break;
            }
            case 9: {
                value = this.getXML(key);
                break;
            }
            case 10: {
                value = this.getData(key);
                break;
            }
            case 11: {
                value = this.getProperties(key);
                break;
            }
            case 8: {
                value = this.getObject(key);
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBoolean(String key, boolean value) throws PropertyException {
        this.lock.lock();
        try {
            this.decoratedPS.setBoolean(key, value);
            this.propertySetCache.setBoolean(key, value);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(String key) throws PropertyException {
        try {
            return this.propertySetCache.getBoolean(key);
        }
        catch (PropertySetCache.NoValueCachedException ex) {
            this.lock.lock();
            try {
                boolean bl = this.propertySetCache.getBoolean(key);
                return bl;
            }
            catch (PropertySetCache.NoValueCachedException ex2) {
                boolean value = this.decoratedPS.getBoolean(key);
                this.propertySetCache.setBoolean(key, value);
                boolean bl = value;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(String key, byte[] value) throws PropertyException {
        this.lock.lock();
        try {
            this.decoratedPS.setData(key, value);
            this.propertySetCache.setData(key, value);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getData(String key) throws PropertyException {
        try {
            return this.propertySetCache.getData(key);
        }
        catch (PropertySetCache.NoValueCachedException ex) {
            this.lock.lock();
            try {
                byte[] byArray = this.propertySetCache.getData(key);
                return byArray;
            }
            catch (PropertySetCache.NoValueCachedException ex2) {
                byte[] value = this.decoratedPS.getData(key);
                this.propertySetCache.setData(key, value);
                byte[] byArray = value;
                return byArray;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDate(String key, Date value) throws PropertyException {
        this.lock.lock();
        try {
            this.decoratedPS.setDate(key, value);
            this.propertySetCache.setDate(key, value);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(String key) throws PropertyException {
        try {
            return this.propertySetCache.getDate(key);
        }
        catch (PropertySetCache.NoValueCachedException ex) {
            this.lock.lock();
            try {
                Date date = this.propertySetCache.getDate(key);
                return date;
            }
            catch (PropertySetCache.NoValueCachedException ex2) {
                Date value = this.decoratedPS.getDate(key);
                this.propertySetCache.setDate(key, value);
                Date date = value;
                return date;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDouble(String key, double value) throws PropertyException {
        this.lock.lock();
        try {
            this.decoratedPS.setDouble(key, value);
            this.propertySetCache.setDouble(key, value);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(String key) throws PropertyException {
        try {
            return this.propertySetCache.getDouble(key);
        }
        catch (PropertySetCache.NoValueCachedException ex) {
            this.lock.lock();
            try {
                double d = this.propertySetCache.getDouble(key);
                return d;
            }
            catch (PropertySetCache.NoValueCachedException ex2) {
                double value = this.decoratedPS.getDouble(key);
                this.propertySetCache.setDouble(key, value);
                double d = value;
                return d;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInt(String key, int value) throws PropertyException {
        this.lock.lock();
        try {
            this.decoratedPS.setInt(key, value);
            this.propertySetCache.setInt(key, value);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(String key) throws PropertyException {
        try {
            return this.propertySetCache.getInt(key);
        }
        catch (PropertySetCache.NoValueCachedException ex) {
            this.lock.lock();
            try {
                int n = this.propertySetCache.getInt(key);
                return n;
            }
            catch (PropertySetCache.NoValueCachedException ex2) {
                int value = this.decoratedPS.getInt(key);
                this.propertySetCache.setInt(key, value);
                int n = value;
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public Collection getKeys() throws PropertyException {
        return this.decoratedPS.getKeys();
    }

    public Collection getKeys(int type) throws PropertyException {
        return this.decoratedPS.getKeys(type);
    }

    public Collection getKeys(String prefix) throws PropertyException {
        return this.decoratedPS.getKeys(prefix);
    }

    public Collection getKeys(String prefix, int type) throws PropertyException {
        return this.decoratedPS.getKeys(prefix, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLong(String key, long value) throws PropertyException {
        this.lock.lock();
        try {
            this.decoratedPS.setLong(key, value);
            this.propertySetCache.setLong(key, value);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(String key) throws PropertyException {
        try {
            return this.propertySetCache.getLong(key);
        }
        catch (PropertySetCache.NoValueCachedException ex) {
            this.lock.lock();
            try {
                long l = this.propertySetCache.getLong(key);
                return l;
            }
            catch (PropertySetCache.NoValueCachedException ex2) {
                long value = this.decoratedPS.getLong(key);
                this.propertySetCache.setLong(key, value);
                long l = value;
                return l;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(String key, Object value) throws PropertyException {
        this.lock.lock();
        try {
            this.decoratedPS.setObject(key, value);
            this.propertySetCache.setObject(key, value);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(String key) throws PropertyException {
        try {
            return this.propertySetCache.getObject(key);
        }
        catch (PropertySetCache.NoValueCachedException ex) {
            this.lock.lock();
            try {
                Object object = this.propertySetCache.getObject(key);
                return object;
            }
            catch (PropertySetCache.NoValueCachedException ex2) {
                Object value = this.decoratedPS.getObject(key);
                this.propertySetCache.setObject(key, value);
                Object object = value;
                return object;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(String key, Properties value) throws PropertyException {
        this.lock.lock();
        try {
            this.decoratedPS.setProperties(key, value);
            this.propertySetCache.setProperties(key, value);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getProperties(String key) throws PropertyException {
        try {
            return this.propertySetCache.getProperties(key);
        }
        catch (PropertySetCache.NoValueCachedException ex) {
            this.lock.lock();
            try {
                Properties properties = this.propertySetCache.getProperties(key);
                return properties;
            }
            catch (PropertySetCache.NoValueCachedException ex2) {
                Properties value = this.decoratedPS.getProperties(key);
                this.propertySetCache.setProperties(key, value);
                Properties properties = value;
                return properties;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void setSchema(PropertySetSchema schema) throws PropertyException {
        this.decoratedPS.setSchema(schema);
    }

    public PropertySetSchema getSchema() throws PropertyException {
        return this.decoratedPS.getSchema();
    }

    public boolean isSettable(String property) {
        return this.decoratedPS.isSettable(property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setString(String key, String value) throws PropertyException {
        this.lock.lock();
        try {
            this.decoratedPS.setString(key, value);
            this.propertySetCache.setString(key, value);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String key) throws PropertyException {
        try {
            return this.propertySetCache.getString(key);
        }
        catch (PropertySetCache.NoValueCachedException ex) {
            this.lock.lock();
            try {
                String string = this.propertySetCache.getString(key);
                return string;
            }
            catch (PropertySetCache.NoValueCachedException ex2) {
                String value = this.decoratedPS.getString(key);
                this.propertySetCache.setObject(key, value);
                String string = value;
                return string;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String key, String value) throws PropertyException {
        this.lock.lock();
        try {
            this.decoratedPS.setText(key, value);
            this.propertySetCache.setText(key, value);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText(String key) throws PropertyException {
        try {
            return this.propertySetCache.getText(key);
        }
        catch (PropertySetCache.NoValueCachedException ex) {
            this.lock.lock();
            try {
                String string = this.propertySetCache.getText(key);
                return string;
            }
            catch (PropertySetCache.NoValueCachedException ex2) {
                String value = this.decoratedPS.getText(key);
                this.propertySetCache.setText(key, value);
                String string = value;
                return string;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getType(String key) throws PropertyException {
        try {
            return this.propertySetCache.getType(key);
        }
        catch (PropertySetCache.NoValueCachedException ex) {
            this.lock.lock();
            try {
                int n = this.propertySetCache.getType(key);
                return n;
            }
            catch (PropertySetCache.NoValueCachedException ex2) {
                int value = this.decoratedPS.getType(key);
                this.propertySetCache.setType(key, value);
                int n = value;
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setXML(String key, Document value) throws PropertyException {
        this.lock.lock();
        try {
            this.decoratedPS.setXML(key, value);
            this.propertySetCache.setXML(key, value);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getXML(String key) throws PropertyException {
        try {
            return this.propertySetCache.getXML(key);
        }
        catch (PropertySetCache.NoValueCachedException ex) {
            this.lock.lock();
            try {
                Document document = this.propertySetCache.getXML(key);
                return document;
            }
            catch (PropertySetCache.NoValueCachedException ex2) {
                Document value = this.decoratedPS.getXML(key);
                this.propertySetCache.setXML(key, value);
                Document document = value;
                return document;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String key) throws PropertyException {
        Boolean exists = this.propertySetCache.exists(key);
        if (exists != null) {
            return exists;
        }
        this.lock.lock();
        try {
            exists = this.propertySetCache.exists(key);
            if (exists != null) {
                boolean bl = exists;
                return bl;
            }
            boolean keyExists = this.decoratedPS.exists(key);
            this.propertySetCache.cacheExistance(key, keyExists);
            boolean bl = keyExists;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Map config, Map args) {
        this.lock.lock();
        try {
            this.decoratedPS = (PropertySet)args.get("PropertySet");
            if (this.decoratedPS == null) {
                throw new NullPointerException("Decorated property set is missing! Cannot initialise.");
            }
            this.propertySetCache = new PropertySetCache();
            Boolean bulkload = (Boolean)args.get("bulkload");
            if (bulkload != null && bulkload.booleanValue()) {
                this.propertySetCache.bulkLoad(this.decoratedPS);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String key) throws PropertyException {
        this.lock.lock();
        try {
            this.propertySetCache.remove(key);
            this.decoratedPS.remove(key);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean supportsType(int type) {
        return this.decoratedPS.supportsType(type);
    }

    public boolean supportsTypes() {
        return this.decoratedPS.supportsTypes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() throws PropertyException {
        this.lock.lock();
        try {
            this.decoratedPS.remove();
            this.propertySetCache.clear();
        }
        finally {
            this.lock.unlock();
        }
    }
}

