/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.association.NodeAssociationStore;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.Update;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.comparator.OfBizComparators;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.PrimitiveMap;
import com.atlassian.jira.project.AbstractProjectManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectCategoryStore;
import com.atlassian.jira.project.ProjectFactory;
import com.atlassian.jira.project.ProjectImpl;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.ProjectRelationConstants;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.util.concurrent.LockManager;
import com.atlassian.util.concurrent.LockManagers;
import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultProjectManager
extends AbstractProjectManager {
    private static final Logger log = Logger.getLogger(DefaultProjectManager.class);
    private static final String PROJECT_ENTITY_NAME = "Project";
    private final OfBizDelegator delegator;
    private final NodeAssociationStore nodeAssociationStore;
    private final ProjectFactory projectFactory;
    private final ProjectRoleManager projectRoleManager;
    private final IssueManager issueManager;
    private final AvatarManager avatarManager;
    private final ProjectCategoryStore projectCategoryStore;
    private final NextIdGenerator nextIdGenerator;

    public DefaultProjectManager() {
        this(ComponentAccessor.getOfBizDelegator(), (NodeAssociationStore)ComponentAccessor.getComponentOfType(NodeAssociationStore.class), ComponentManager.getComponentInstanceOfType(ProjectFactory.class), ComponentManager.getComponentInstanceOfType(ProjectRoleManager.class), ComponentManager.getComponentInstanceOfType(IssueManager.class), ComponentManager.getComponentInstanceOfType(AvatarManager.class), ComponentManager.getComponentInstanceOfType(UserManager.class), (ProjectCategoryStore)ComponentAccessor.getComponentOfType(ProjectCategoryStore.class), ComponentAccessor.getApplicationProperties());
    }

    public DefaultProjectManager(OfBizDelegator delegator, NodeAssociationStore nodeAssociationStore, ProjectFactory projectFactory, ProjectRoleManager projectRoleManager, IssueManager issueManager, AvatarManager avatarManager, UserManager userManager, ProjectCategoryStore projectCategoryStore, ApplicationProperties applicationProperties) {
        super(userManager, applicationProperties);
        this.delegator = delegator;
        this.nodeAssociationStore = nodeAssociationStore;
        this.projectFactory = projectFactory;
        this.projectRoleManager = projectRoleManager;
        this.issueManager = issueManager;
        this.avatarManager = avatarManager;
        this.projectCategoryStore = projectCategoryStore;
        this.nextIdGenerator = new NextIdGenerator(this, delegator);
    }

    public Project createProject(String name, String key, String description, String lead, String url, Long assigneeType, Long avatarId) {
        Assertions.notNull((String)"key", (Object)key);
        Assertions.notNull((String)"name", (Object)name);
        Assertions.notNull((String)"lead", (Object)lead);
        if (avatarId == null) {
            avatarId = this.avatarManager.getDefaultAvatarId(Avatar.Type.PROJECT);
        }
        Map<String, Object> params = new PrimitiveMap.Builder().add("key", key).add("name", name).add("url", url).add("lead", lead).add("description", description).add("counter", 0L).add("assigneetype", assigneeType).add("avatar", avatarId).toMap();
        GenericValue projectGV = this.delegator.createValue(PROJECT_ENTITY_NAME, params);
        ProjectImpl newProject = new ProjectImpl(projectGV);
        this.projectRoleManager.applyDefaultsRolesToProject((Project)newProject);
        this.nextIdGenerator.newProject(newProject.getId());
        return newProject;
    }

    public long getNextId(Project project) {
        return this.nextIdGenerator.getNextId(project);
    }

    private boolean counterAlreadyExists(Project project, long counter) {
        boolean alreadyExists;
        String issueKey = project.getKey() + "-" + counter;
        List result = this.getDelegator().findByAnd("Issue", (Map)FieldMap.build((String)"key", (Object)issueKey));
        boolean bl = alreadyExists = !result.isEmpty();
        if (alreadyExists) {
            log.warn((Object)("Existing issue found for key " + issueKey + ". Incrementing key."));
        }
        return alreadyExists;
    }

    public Project updateProject(Project updatedProject, String name, String description, String lead, String url, Long assigneeType, Long avatarId) {
        Assertions.notNull((String)"project", (Object)updatedProject);
        Assertions.notNull((String)"name", (Object)name);
        Assertions.notNull((String)"lead", (Object)lead);
        GenericValue projectUpdate = this.delegator.makeValue(PROJECT_ENTITY_NAME);
        projectUpdate.set("id", (Object)updatedProject.getId());
        projectUpdate.setString("name", name);
        projectUpdate.setString("url", url);
        projectUpdate.setString("lead", lead);
        projectUpdate.setString("description", description);
        projectUpdate.set("assigneetype", (Object)assigneeType);
        if (avatarId != null) {
            projectUpdate.set("avatar", (Object)avatarId);
        }
        this.delegator.store(projectUpdate);
        this.getIssueSecurityLevelManager().clearUsersLevels();
        return this.getProjectObj(updatedProject.getId());
    }

    public void removeProjectIssues(Project project) throws RemoveException {
        Collection issueIds;
        Assertions.notNull((String)"project", (Object)project);
        try {
            issueIds = this.issueManager.getIssueIdsForProject(project.getId());
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        for (Long issueId : issueIds) {
            MutableIssue issue = this.issueManager.getIssueObject(issueId);
            if (issue != null) {
                try {
                    this.issueManager.deleteIssueNoEvent((Issue)issue);
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)"Exception removing issues", (Throwable)e);
                    throw new RemoveException("Error removing issues: " + e, e);
                }
            }
            log.debug((Object)("Issue with id '" + issueId + "' was not found. Most likely it is a sub-task and has been deleted previously with its parent."));
        }
    }

    public void removeProject(Project project) {
        Assertions.notNull((String)"project", (Object)project);
        this.projectRoleManager.removeAllRoleActorsByProject(project);
        Delete.from(PROJECT_ENTITY_NAME).whereIdEquals(project.getId()).execute(this.delegator);
    }

    public GenericValue getProject(Long id) {
        return this.getDelegator().findById(PROJECT_ENTITY_NAME, id);
    }

    public Project getProjectObj(Long id) {
        Project project = null;
        GenericValue gv = this.getProject(id);
        if (gv != null) {
            project = this.projectFactory.getProject(gv);
        }
        return project;
    }

    public GenericValue getProjectByName(String name) {
        return EntityUtil.getOnly((List)this.getDelegator().findByAnd(PROJECT_ENTITY_NAME, (Map)FieldMap.build((String)"name", (Object)name)));
    }

    public GenericValue getProjectByKey(String key) {
        return EntityUtil.getOnly((List)this.getDelegator().findByAnd(PROJECT_ENTITY_NAME, (Map)FieldMap.build((String)"key", (Object)key)));
    }

    public Project getProjectObjByKey(String projectKey) {
        Project project = null;
        GenericValue projectGv = this.getProjectByKey(projectKey);
        if (projectGv != null) {
            project = this.projectFactory.getProject(projectGv);
        }
        return project;
    }

    public Project getProjectObjByKeyIgnoreCase(String projectKey) {
        Project project = null;
        GenericValue projectGv = this.getProjectByKey(projectKey);
        if (projectGv == null) {
            for (Project prj : this.getProjectObjects()) {
                if (!prj.getKey().equalsIgnoreCase(projectKey)) continue;
                project = prj;
                break;
            }
        } else {
            project = this.projectFactory.getProject(projectGv);
        }
        return project;
    }

    public Project getProjectObjByName(String projectName) {
        Project project = null;
        GenericValue projectGv = this.getProjectByName(projectName);
        if (projectGv != null) {
            project = this.projectFactory.getProject(projectGv);
        }
        return project;
    }

    @Deprecated
    public GenericValue getComponent(Long id) {
        return this.getDelegator().findById("Component", id);
    }

    @Deprecated
    public GenericValue getComponent(GenericValue project, String name) {
        return EntityUtil.getOnly((List)this.getDelegator().findByAnd("Component", (Map)FieldMap.build((String)"project", (Object)project.getLong("id"), (String)"name", (Object)name)));
    }

    @Deprecated
    public Collection<GenericValue> getComponents(GenericValue project) {
        try {
            return project.getRelated("ChildComponent", Collections.emptyMap(), Collections.singletonList("name"));
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public Collection<GenericValue> getProjects() {
        List allProjects = this.getDelegator().findAll(PROJECT_ENTITY_NAME, CollectionBuilder.list((Object[])new String[]{"name"}));
        Collections.sort(allProjects, OfBizComparators.NAME_COMPARATOR);
        return allProjects;
    }

    public List<Project> getProjectObjects() throws DataAccessException {
        Collection<GenericValue> projectGVs = this.getProjects();
        return this.projectFactory.getProjects(projectGVs);
    }

    protected OfBizDelegator getDelegator() {
        return this.delegator;
    }

    public Collection<GenericValue> getProjectCategories() {
        return this.getDelegator().findAll("ProjectCategory", EasyList.build((Object)"name"));
    }

    public List<ProjectCategory> getAllProjectCategories() {
        return this.projectCategoryStore.getAllProjectCategories();
    }

    public GenericValue getProjectCategory(Long id) {
        return this.getDelegator().findByPrimaryKey("ProjectCategory", id);
    }

    public ProjectCategory getProjectCategoryObject(Long id) {
        return this.projectCategoryStore.getProjectCategory(id);
    }

    public void updateProjectCategory(GenericValue projectCat) {
        this.getDelegator().storeAll(CollectionBuilder.newBuilder((Object[])new GenericValue[]{projectCat}).asList());
    }

    public void updateProjectCategory(ProjectCategory projectCategory) throws DataAccessException {
        this.projectCategoryStore.updateProjectCategory(projectCategory);
    }

    public Collection<GenericValue> getProjectsFromProjectCategory(GenericValue projectCategory) {
        if (null == projectCategory) {
            return Collections.emptyList();
        }
        List<GenericValue> projects = this.nodeAssociationStore.getSourcesFromSink(projectCategory, PROJECT_ENTITY_NAME, "ProjectCategory");
        Collections.sort(projects, OfBizComparators.NAME_COMPARATOR);
        return projects;
    }

    public Collection<Project> getProjectsFromProjectCategory(ProjectCategory projectCategory) throws DataAccessException {
        return this.getProjectObjectsFromProjectCategory(projectCategory.getId());
    }

    public Collection<Project> getProjectObjectsFromProjectCategory(Long projectCategoryId) {
        return this.projectFactory.getProjects(this.getProjectsFromProjectCategory(this.getProjectCategory(projectCategoryId)));
    }

    public Collection<GenericValue> getProjectsWithNoCategory() {
        ArrayList<GenericValue> result = new ArrayList<GenericValue>();
        for (GenericValue project : this.getProjects()) {
            if (this.getProjectCategoryFromProject(project) != null) continue;
            result.add(project);
        }
        Collections.sort(result, OfBizComparators.NAME_COMPARATOR);
        return result;
    }

    public Collection<Project> getProjectObjectsWithNoCategory() throws DataAccessException {
        return this.projectFactory.getProjects(this.getProjectsWithNoCategory());
    }

    public GenericValue getProjectCategoryFromProject(GenericValue project) {
        if (null == project) {
            return null;
        }
        List<GenericValue> projectCats = this.nodeAssociationStore.getSinksFromSource(project, "ProjectCategory", "ProjectCategory");
        if (null == projectCats || projectCats.isEmpty()) {
            return null;
        }
        return projectCats.iterator().next();
    }

    public ProjectCategory getProjectCategoryForProject(Project project) throws DataAccessException {
        if (project == null) {
            return null;
        }
        List<GenericValue> projectCats = this.nodeAssociationStore.getSinksFromSource(PROJECT_ENTITY_NAME, project.getId(), "ProjectCategory", "ProjectCategory");
        if (null == projectCats || projectCats.isEmpty()) {
            return null;
        }
        return (ProjectCategory)Entity.PROJECT_CATEGORY.build(projectCats.get(0));
    }

    public ProjectCategory createProjectCategory(String name, String description) {
        return this.projectCategoryStore.createProjectCategory(name, description);
    }

    public void removeProjectCategory(Long id) {
        this.projectCategoryStore.removeProjectCategory(id);
    }

    public void setProjectCategory(GenericValue project, GenericValue category) {
        if (project == null) {
            throw new IllegalArgumentException("Cannot associate a category with a null project");
        }
        GenericValue oldProjectCategory = this.getProjectCategoryFromProject(project);
        if (null != oldProjectCategory) {
            this.nodeAssociationStore.removeAssociation(project, oldProjectCategory, "ProjectCategory");
        }
        if (null != category) {
            this.nodeAssociationStore.createAssociation(project, category, "ProjectCategory");
        }
    }

    public void setProjectCategory(Project project, ProjectCategory category) {
        if (project == null) {
            throw new IllegalArgumentException("Cannot associate a category with a null project");
        }
        ProjectCategory oldProjectCategory = this.getProjectCategoryForProject(project);
        if (oldProjectCategory != null) {
            this.nodeAssociationStore.removeAssociation(ProjectRelationConstants.PROJECT_CATEGORY_ASSOC, project.getId(), oldProjectCategory.getId());
        }
        if (category != null) {
            this.nodeAssociationStore.createAssociation(ProjectRelationConstants.PROJECT_CATEGORY_ASSOC, project.getId(), category.getId());
        }
    }

    public List<Project> getProjectsLeadBy(User leadUser) {
        List<GenericValue> projects = this.findProjectsByLead(leadUser);
        return this.projectFactory.getProjects(projects);
    }

    public final Collection<GenericValue> getProjectsByLead(User leadUser) {
        return this.findProjectsByLead(leadUser);
    }

    private List<GenericValue> findProjectsByLead(User leadUser) {
        if (leadUser == null) {
            return Collections.emptyList();
        }
        return this.getDelegator().findByAnd(PROJECT_ENTITY_NAME, (Map)FieldMap.build((String)"lead", (Object)leadUser.getName()), CollectionBuilder.list((Object[])new String[]{"name"}));
    }

    public void refresh() {
        this.nextIdGenerator.refresh();
    }

    IssueSecurityLevelManager getIssueSecurityLevelManager() {
        return ComponentManager.getComponentInstanceOfType(IssueSecurityLevelManager.class);
    }

    public long getCurrentCounterForProject(Long id) {
        return this.nextIdGenerator.getCurrentCounterForProject(id);
    }

    public void setCurrentCounterForProject(Project project, long counter) {
        this.nextIdGenerator.resetCounter(project, counter);
    }

    private static class ProjectCounterCache {
        private final ConcurrentMap<Long, AtomicLong> projectCounterCache = new MapMaker().makeComputingMap((Function)new Function<Long, AtomicLong>(){

            public AtomicLong apply(@Nullable Long projectId) {
                return new AtomicLong(ProjectCounterCache.this.readCounterFromDatabase(projectId));
            }
        });
        private final ProjectManager projectManager;

        public ProjectCounterCache(ProjectManager projectManager) {
            this.projectManager = projectManager;
            this.refresh();
        }

        public void refresh() {
            this.populateCache();
        }

        public void newProject(Long projectId) {
            this.populateCache(projectId, 0L);
        }

        public long getNextCounterForProject(long id) {
            return ((AtomicLong)this.projectCounterCache.get(id)).incrementAndGet();
        }

        public long getCurrentCounterForProject(long id) {
            AtomicLong counter = (AtomicLong)this.projectCounterCache.get(id);
            return counter != null ? counter.longValue() : 0L;
        }

        private void populateCache() {
            this.projectCounterCache.clear();
            for (GenericValue project : this.projectManager.getProjects()) {
                this.populateCache(project.getLong("id"), project.getLong("counter"));
            }
        }

        private void populateCache(Long projectId, Long counter) {
            counter = counter == null ? 0L : counter;
            this.projectCounterCache.putIfAbsent(projectId, new AtomicLong(counter));
        }

        private void setCurrentCounterForProject(Long projectId, long counter) {
            this.projectCounterCache.put(projectId, new AtomicLong(counter));
        }

        private long readCounterFromDatabase(Long projectId) {
            GenericValue project = this.projectManager.getProject(projectId);
            if (project != null) {
                return project.getLong("counter");
            }
            return 0L;
        }
    }

    private static class ProjectCountUpdater
    implements Callable<Void> {
        final OfBizDelegator delegator;
        private final Long projectId;
        private final long counter;

        public ProjectCountUpdater(OfBizDelegator delegator, Long projectId, long counter) {
            this.projectId = projectId;
            this.counter = counter;
            this.delegator = delegator;
        }

        @Override
        public Void call() {
            Update.into(DefaultProjectManager.PROJECT_ENTITY_NAME).set("counter", this.counter).whereEqual("id", this.projectId).execute(this.delegator);
            return null;
        }
    }

    static class NextIdGenerator {
        private final OfBizDelegator ofBizDelegator;
        private final ProjectCounterCache projectCounterCache;
        private final ExecutorService projectCountUpdateService = Executors.newFixedThreadPool(4, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ProjectCounterUpdateThread-%d").build());
        private final LockManager<Project> lockManager = LockManagers.weakLockManager((com.atlassian.util.concurrent.Function)new com.atlassian.util.concurrent.Function<Project, Long>(){

            public Long get(Project input) {
                return input.getId();
            }
        });

        NextIdGenerator(ProjectManager projectManager, OfBizDelegator delegator) {
            this.ofBizDelegator = delegator;
            this.projectCounterCache = new ProjectCounterCache(projectManager);
        }

        private void updateProject(Long projectId, long current) {
            Future<Void> futureUpdater = this.projectCountUpdateService.submit(new ProjectCountUpdater(this.ofBizDelegator, projectId, current));
            try {
                futureUpdater.get();
            }
            catch (Exception e) {
                log.error((Object)("Cannot update project counter due to " + e.getMessage()));
            }
        }

        long getNextId(Project project) {
            long incCount;
            if (project == null) {
                throw new IllegalArgumentException();
            }
            final Long id = project.getId();
            final String projectKey = project.getKey();
            try {
                incCount = (Long)this.lockManager.withLock((Object)project, (Callable)new Callable<Long>(){

                    @Override
                    public Long call() {
                        Long result;
                        while (NextIdGenerator.this.counterAlreadyExists(result = Long.valueOf(NextIdGenerator.this.projectCounterCache.getNextCounterForProject(id)), projectKey)) {
                        }
                        NextIdGenerator.this.updateProject(id, result);
                        return result;
                    }
                });
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return incCount;
        }

        long getCurrentCounterForProject(long id) {
            return this.projectCounterCache.getCurrentCounterForProject(id);
        }

        public void refresh() {
            this.projectCounterCache.refresh();
        }

        public void newProject(Long projectId) {
            this.projectCounterCache.newProject(projectId);
        }

        private boolean counterAlreadyExists(long incCount, String projectKey) {
            boolean alreadyExists;
            String issueKey = projectKey + "-" + incCount;
            List result = this.ofBizDelegator.findByAnd("Issue", (Map)FieldMap.build((String)"key", (Object)issueKey));
            boolean bl = alreadyExists = !result.isEmpty();
            if (alreadyExists) {
                log.error((Object)("Existing issue found for key " + issueKey + ". Incrementing key."));
            }
            return alreadyExists;
        }

        public void resetCounter(final Project project, final long counter) {
            this.lockManager.withLock((Object)project, new Runnable(){

                @Override
                public void run() {
                    Long id = project.getId();
                    new ProjectCountUpdater(NextIdGenerator.this.ofBizDelegator, id, counter).call();
                    NextIdGenerator.this.projectCounterCache.setCurrentCounterForProject(id, counter);
                }
            });
        }
    }
}

