/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.workflow;

import com.atlassian.jira.plugin.AbstractJiraModuleDescriptor;
import com.atlassian.jira.plugin.ComponentClassManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.workflow.OSWorkflowConfigurator;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.PluginState;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.module.ModuleFactory;
import com.opensymphony.workflow.TypeResolver;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public abstract class AbstractWorkflowModuleDescriptor<T>
extends AbstractJiraModuleDescriptor<T>
implements Comparable<AbstractWorkflowModuleDescriptor<T>> {
    private static final Logger log = Logger.getLogger(AbstractWorkflowModuleDescriptor.class);
    private final OSWorkflowConfigurator workflowConfigurator;
    private final ComponentClassManager componentClassManager;
    private TypeResolver typeResolver;
    private Class<T> implementationClass;
    private String implementationClassName;

    public AbstractWorkflowModuleDescriptor(JiraAuthenticationContext authenticationContext, OSWorkflowConfigurator workflowConfigurator, ComponentClassManager componentClassManager, ModuleFactory moduleFactory) {
        super(authenticationContext, moduleFactory);
        this.workflowConfigurator = workflowConfigurator;
        this.componentClassManager = componentClassManager;
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.implementationClassName = element.element(this.getParameterName()).getTextTrim();
    }

    @Override
    public void enabled() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Plugin '%s' is attempting to register workflow module '%s'.", this.getKey(), this.implementationClassName));
        }
        try {
            this.implementationClass = this.getPlugin().loadClass(this.implementationClassName, this.getClass());
        }
        catch (ClassNotFoundException ex) {
            throw new PluginException("Cannot load condition class '" + this.implementationClassName + "'. " + ex.getMessage());
        }
        super.enabled();
        this.registerWorkflowTypeResolver();
    }

    private void registerWorkflowTypeResolver() {
        this.typeResolver = new PluginTypeResolver();
        this.workflowConfigurator.registerTypeResolver(this.implementationClassName, this.typeResolver);
    }

    @Override
    public void disabled() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Plugin '%s' is attempting to unregister workflow module '%s'.", this.getKey(), this.implementationClassName));
        }
        super.disabled();
        this.implementationClass = null;
        this.unregisterWorkflowTypeResolver();
    }

    private void unregisterWorkflowTypeResolver() {
        this.workflowConfigurator.unregisterTypeResolver(this.implementationClassName, this.typeResolver);
        this.typeResolver = null;
    }

    protected abstract String getParameterName();

    protected String getParamValue(Element element, String paramName) {
        if (element.element(paramName) != null && element.element(paramName).getTextTrim() != null) {
            return element.element(paramName).getTextTrim();
        }
        return null;
    }

    public Class<T> getImplementationClass() {
        return this.implementationClass;
    }

    @Override
    public int compareTo(AbstractWorkflowModuleDescriptor<T> o) {
        if (o == null) {
            return 1;
        }
        if (o.getName() != null) {
            if (this.getName() != null) {
                return this.getName().compareTo(o.getName());
            }
            return -1;
        }
        if (this.getName() == null) {
            return 0;
        }
        return 1;
    }

    public abstract String getHtml(String var1, AbstractDescriptor var2);

    public abstract boolean isOrderable();

    public abstract boolean isUnique();

    public abstract boolean isDeletable();

    public abstract boolean isAddable(String var1);

    public boolean isEditable() {
        ResourceDescriptor resourceDescriptor = this.getResourceDescriptor("velocity", "edit-parameters");
        return resourceDescriptor != null;
    }

    class PluginTypeResolver
    extends TypeResolver {
        PluginTypeResolver() {
        }

        protected Object loadObject(String clazz) {
            Plugin plugin = AbstractWorkflowModuleDescriptor.this.getPlugin();
            if (plugin == null) {
                throw new IllegalStateException("Plugin '" + AbstractWorkflowModuleDescriptor.this.getKey() + "' not available unexpectedly");
            }
            if (!plugin.getPluginState().equals((Object)PluginState.ENABLED)) {
                log.warn((Object)("Plugin " + AbstractWorkflowModuleDescriptor.this.getKey() + " not enabled."));
                return null;
            }
            return AbstractWorkflowModuleDescriptor.this.componentClassManager.newInstanceFromPlugin(AbstractWorkflowModuleDescriptor.this.getImplementationClass(), plugin);
        }
    }
}

