/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.conditions;

import com.atlassian.gadgets.dashboard.DashboardId;
import com.atlassian.gadgets.dashboard.spi.DashboardPermissionService;
import com.atlassian.jira.ComponentManager;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class IsDashboardOwnerCondition
implements Condition {
    public static final String CONTEXT_KEY_DASHBOARD_ID = "dashboardId";

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        DashboardId dashboardId = (DashboardId)context.get(CONTEXT_KEY_DASHBOARD_ID);
        String username = (String)context.get("username");
        return dashboardId != null && StringUtils.isNotBlank((String)username) && this.getPermissionService().isWritableBy(dashboardId, username);
    }

    DashboardPermissionService getPermissionService() {
        return ComponentManager.getComponentInstanceOfType(DashboardPermissionService.class);
    }
}

