/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.report.impl;

import com.atlassian.jira.plugin.report.impl.DurationFormatter;
import com.atlassian.jira.util.JiraDurationUtils;
import com.atlassian.jira.web.bean.I18nBean;

class DurationFormatterImpl
implements DurationFormatter {
    private final JiraDurationUtils jiraDurationUtils;
    private final I18nBean i18nBean;

    DurationFormatterImpl(I18nBean i18nBean, JiraDurationUtils jiraDurationUtils) {
        this.i18nBean = i18nBean;
        this.jiraDurationUtils = jiraDurationUtils;
    }

    @Override
    public String format(Long duration) {
        if (duration == null) {
            return "-";
        }
        duration = new Long(Math.abs(duration));
        return this.jiraDurationUtils.getFormattedDuration(duration, this.i18nBean.getLocale());
    }

    @Override
    public String shortFormat(Long duration) {
        if (duration == null) {
            return "-";
        }
        duration = new Long(Math.abs(duration));
        return this.jiraDurationUtils.getShortFormattedDuration(duration);
    }
}

