/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.renderercomponent;

import com.atlassian.jira.plugin.PluginInjector;
import com.atlassian.jira.plugin.renderercomponent.RendererComponentFactoryDescriptor;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.renderer.v2.components.PluggableRendererComponentFactory;
import com.atlassian.renderer.v2.components.RendererComponent;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class SimpleRendererComponentFactory
implements PluggableRendererComponentFactory {
    private static final String RENDERER_COMPONENT_CLASS_PARAM = "rendererComponentClass";
    private RendererComponent rendererComponent;
    private Class<RendererComponent> rendererComponentClass;
    private Plugin plugin;

    public void init(ModuleDescriptor moduleDescriptor) throws PluginParseException {
        this.plugin = moduleDescriptor.getPlugin();
        RendererComponentFactoryDescriptor descriptor = (RendererComponentFactoryDescriptor)moduleDescriptor;
        Map params = descriptor.getParams();
        if (params == null || StringUtils.isEmpty((String)((String)params.get(RENDERER_COMPONENT_CLASS_PARAM)))) {
            throw new PluginParseException("The plugin with key '" + descriptor.getCompleteKey() + "' is missing the required '" + RENDERER_COMPONENT_CLASS_PARAM + "' parameter.");
        }
        String rendererComponentClassName = (String)params.get(RENDERER_COMPONENT_CLASS_PARAM);
        try {
            this.rendererComponentClass = moduleDescriptor.getPlugin().loadClass(rendererComponentClassName, this.getClass());
        }
        catch (ClassNotFoundException e) {
            throw new PluginParseException("Could not load renderer component with class '" + rendererComponentClassName + "' for plugin with key '" + descriptor.getCompleteKey() + "'", (Throwable)e);
        }
    }

    public RendererComponent getRendererComponent() {
        if (this.rendererComponent == null) {
            try {
                this.rendererComponent = this.loadRendererComponent(this.rendererComponentClass);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return this.rendererComponent;
    }

    RendererComponent loadRendererComponent(Class<RendererComponent> rendererComponentClass) throws ClassNotFoundException {
        if (this.plugin == null) {
            throw new IllegalStateException("SimpleRendererComponentFactory has not been initialised.");
        }
        return PluginInjector.newInstance(rendererComponentClass, this.plugin);
    }
}

