/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.jql.function;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.validator.NumberOfArgumentsValidator;
import com.atlassian.jira.plugin.jql.function.AbstractJqlFunction;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.FunctionOperand;
import java.util.Collections;
import java.util.List;

public abstract class AbstractUserBasedFunction
extends AbstractJqlFunction {
    private static final int MIN_EXPECTED_ARGS = 0;
    private static final int MAX_EXPECTED_ARGS = 1;
    protected final UserUtil userUtil;

    public AbstractUserBasedFunction(UserUtil userUtil) {
        this.userUtil = (UserUtil)Assertions.notNull((String)"userUtil", (Object)userUtil);
    }

    public MessageSet validate(User searcher, FunctionOperand functionOperand, TerminalClause terminalClause) {
        I18nHelper i18n = this.getI18n();
        if (functionOperand.getArgs().size() != 0 || searcher != null) {
            String username;
            MessageSet messages = this.validateNumberOfArgs(functionOperand, i18n);
            if (!messages.hasAnyErrors() && functionOperand.getArgs().size() == 1 && this.userUtil.getUserObject(username = (String)functionOperand.getArgs().get(0)) == null) {
                messages.addErrorMessage(i18n.getText(this.getUserNotFoundMessageKey(), functionOperand.getName(), username));
            }
            return messages;
        }
        MessageSetImpl messageSet = new MessageSetImpl();
        messageSet.addErrorMessage(i18n.getText("jira.jql.function.anonymous.disallowed", this.getFunctionName()));
        return messageSet;
    }

    private MessageSet validateNumberOfArgs(FunctionOperand functionOperand, I18nHelper i18n) {
        return new NumberOfArgumentsValidator(0, 1, i18n).validate(functionOperand);
    }

    public int getMinimumNumberOfExpectedArguments() {
        return 0;
    }

    public List<QueryLiteral> getValues(QueryCreationContext queryCreationContext, FunctionOperand functionOperand, TerminalClause terminalClause) {
        User user;
        Assertions.notNull((String)"queryCreationContext", (Object)queryCreationContext);
        if (functionOperand.getArgs().size() == 1) {
            String username = (String)functionOperand.getArgs().get(0);
            user = this.userUtil.getUserObject(username);
        } else {
            user = queryCreationContext.getQueryUser();
        }
        if (user == null) {
            return Collections.emptyList();
        }
        return this.getFunctionValuesList(queryCreationContext, functionOperand, user);
    }

    protected abstract List<QueryLiteral> getFunctionValuesList(QueryCreationContext var1, FunctionOperand var2, User var3);

    protected abstract String getUserNotFoundMessageKey();
}

