/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.assignee.impl;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.ComponentsSystemField;
import com.atlassian.jira.plugin.assignee.AssigneeResolver;
import com.atlassian.jira.project.DefaultAssigneeException;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;

public class DefaultAssigneeResolver
implements AssigneeResolver {
    private static final Logger log = Logger.getLogger(DefaultAssigneeResolver.class);
    private final ProjectManager projectManager;
    private final JiraAuthenticationContext authenticationContext;

    public DefaultAssigneeResolver(ProjectManager projectManager, JiraAuthenticationContext authenticationContext) {
        this.projectManager = projectManager;
        this.authenticationContext = authenticationContext;
    }

    @Override
    public ErrorCollection validateDefaultAssignee(Issue issue, Map fieldValuesHolder) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        try {
            this.getDefaultAssigneeObject(issue, fieldValuesHolder);
        }
        catch (DefaultAssigneeException ex) {
            log.warn((Object)ex.getMessage());
            errorCollection.addError("assignee", this.authenticationContext.getI18nHelper().getText("assign.error.unassignabledefault"), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        return errorCollection;
    }

    @Override
    public User getDefaultAssignee(Issue issue, Map fieldValuesHolder) {
        return this.getDefaultAssigneeObject(issue, fieldValuesHolder);
    }

    @Override
    public User getDefaultAssigneeObject(Issue issue, Map fieldValuesHolder) {
        Collection<Object> components = this.getComponentsSystemField().getComponentsFromParams(fieldValuesHolder);
        if (components == null) {
            components = issue.getComponentObjects();
        }
        return this.projectManager.getDefaultAssignee(issue.getProjectObject(), components);
    }

    private ComponentsSystemField getComponentsSystemField() {
        return (ComponentsSystemField)ComponentManager.getInstance().getFieldManager().getField("components");
    }
}

