/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin;

import com.atlassian.annotations.Internal;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.portal.FlushablePortletConfigurationStore;
import com.atlassian.jira.portal.PortletConfigurationStore;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;

@Internal
public class JiraCacheResetter {
    private final Delegate delegate = new Delegate();

    public JiraCacheResetter(EventPublisher eventPublisher) {
        eventPublisher.register((Object)this.delegate);
    }

    private static void resetCaches() {
        PortletConfigurationStore store;
        FieldScreenManager screenManager;
        FieldManager fieldManager;
        CustomFieldManager customFieldManager = ComponentAccessor.getCustomFieldManager();
        if (customFieldManager != null) {
            customFieldManager.refresh();
        }
        if ((fieldManager = ComponentAccessor.getFieldManager()) != null) {
            fieldManager.refresh();
        }
        if ((screenManager = ComponentAccessor.getFieldScreenManager()) != null) {
            screenManager.refresh();
        }
        if ((store = (PortletConfigurationStore)ComponentAccessor.getComponent(PortletConfigurationStore.class)) instanceof FlushablePortletConfigurationStore) {
            ((FlushablePortletConfigurationStore)store).flush();
        }
    }

    public static class Delegate {
        @EventListener
        public void onPluginDisabled(PluginDisabledEvent pluginDisabledEvent) {
            JiraCacheResetter.resetCaches();
        }

        @EventListener
        public void onPluginEnabled(PluginEnabledEvent pluginEnabledEvent) {
            JiraCacheResetter.resetCaches();
        }

        @EventListener
        public void onPluginModuleDisabled(PluginModuleDisabledEvent pluginModuleDisabledEvent) {
            JiraCacheResetter.resetCaches();
        }

        @EventListener
        public void onPluginModuleEnabled(PluginModuleEnabledEvent pluginModuleEnabledEvent) {
            JiraCacheResetter.resetCaches();
        }
    }
}

