/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.util.List;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class PermissionContextImpl
implements PermissionContext {
    private static final Logger log = Logger.getLogger(PermissionContextImpl.class);
    final Project project;
    final Issue issue;
    final Status status;

    public PermissionContextImpl(Issue issue, Project project, Status status) {
        this.project = project;
        this.issue = issue;
        this.status = status;
    }

    public final GenericValue getProject() {
        return this.project.getGenericValue();
    }

    public final Project getProjectObject() {
        return this.project;
    }

    public Issue getIssue() {
        return this.issue;
    }

    public boolean isHasCreatedIssue() {
        return this.issue != null && this.issue.getIssueTypeObject() != null;
    }

    public Status getStatus() {
        return this.status;
    }

    public StepDescriptor getRelevantStepDescriptor() {
        JiraWorkflow workflow;
        if (this.issue == null) {
            throw new IllegalArgumentException("Issue not passed into workflow-based permission scheme");
        }
        try {
            WorkflowManager workflowManager = ComponentAccessor.getWorkflowManager();
            workflow = workflowManager.getWorkflow(this.getIssue());
        }
        catch (WorkflowException e) {
            log.error((Object)("Could not find workflow for issue " + this.getIssue()), (Throwable)e);
            throw new RuntimeException("Could not find workflow for issue " + this.getIssue());
        }
        if (!this.getIssue().isCreated()) {
            return this.getInitialStepDescriptor(workflow);
        }
        return workflow.getLinkedStep(this.getStatusGV());
    }

    private GenericValue getStatusGV() throws RuntimeException {
        Status status = this.getStatus();
        if (status != null) {
            return status.getGenericValue();
        }
        Status issueStatus = this.getIssue().getStatusObject();
        if (issueStatus == null) {
            throw new RuntimeException("Could not find workflow status for issue " + this.getIssue().getKey() + ".");
        }
        return issueStatus.getGenericValue();
    }

    private StepDescriptor getInitialStepDescriptor(JiraWorkflow workflow) {
        List initialActions = workflow.getDescriptor().getInitialActions();
        ActionDescriptor initialAction = (ActionDescriptor)initialActions.get(0);
        int initialStep = initialAction.getUnconditionalResult().getStep();
        return workflow.getDescriptor().getStep(initialStep);
    }

    public boolean hasIssuePermissions() {
        return this.issue != null && this.issue.getIssueTypeObject() != null;
    }
}

