/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.notification.type;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.notification.type.AbstractNotificationType;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.opensymphony.util.TextUtils;
import java.util.List;
import java.util.Map;

public class SingleEmailAddress
extends AbstractNotificationType {
    private JiraAuthenticationContext jiraAuthenticationContext;

    public SingleEmailAddress(JiraAuthenticationContext jiraAuthenticationContext) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public List getRecipients(IssueEvent event, String emailAddress) {
        return EasyList.build((Object)new NotificationRecipient(emailAddress));
    }

    @Override
    public String getDisplayName() {
        return this.jiraAuthenticationContext.getI18nHelper().getText("admin.notification.types.single.email.address");
    }

    @Override
    public String getType() {
        return "email";
    }

    @Override
    public boolean doValidation(String key, Map parameters) {
        Object value = parameters.get(key);
        return value != null && TextUtils.verifyEmail((String)((String)value));
    }
}

