/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.notification.type;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.notification.type.AbstractNotificationType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import java.util.Collections;
import java.util.List;

public class ProjectLead
extends AbstractNotificationType {
    private JiraAuthenticationContext jiraAuthenticationContext;

    public ProjectLead(JiraAuthenticationContext jiraAuthenticationContext) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Override
    public List<NotificationRecipient> getRecipients(IssueEvent event, String argument) {
        Project project = event.getIssue().getProjectObject();
        User u = project.getLead();
        if (u == null) {
            return Collections.emptyList();
        }
        return EasyList.build((Object)new NotificationRecipient(u));
    }

    @Override
    public String getDisplayName() {
        return this.jiraAuthenticationContext.getI18nHelper().getText("admin.notification.types.project.lead");
    }
}

